/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.parameter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stateless.parameter.AbstractSecretBasedParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProvider;
import org.apache.nifi.stateless.parameter.ParameterValueProviderInitializationContext;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.StandardHashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultConfiguration;
import org.springframework.core.env.PropertySource;

public class HashiCorpVaultParameterValueProvider
extends AbstractSecretBasedParameterValueProvider
implements ParameterValueProvider {
    private static final String KEY_VALUE_PATH = "vault.kv.path";
    public static final PropertyDescriptor VAULT_CONFIG_FILE = new PropertyDescriptor.Builder().displayName("Vault Configuration File").name("vault-configuration-file").required(true).defaultValue("./conf/bootstrap-hashicorp-vault.conf").description("Location of the bootstrap-hashicorp-vault.conf file that configures the Vault connection").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    private HashiCorpVaultCommunicationService vaultCommunicationService;
    private String path;

    protected List<PropertyDescriptor> getAdditionalSupportedPropertyDescriptors() {
        return Collections.singletonList(VAULT_CONFIG_FILE);
    }

    protected void additionalInit(ParameterValueProviderInitializationContext context) {
        String vaultBootstrapConfFilename = context.getProperty(VAULT_CONFIG_FILE).getValue();
        this.configure(vaultBootstrapConfFilename);
    }

    void configure(String vaultBootstrapConfFilename) {
        try {
            PropertySource propertySource = HashiCorpVaultConfiguration.createPropertiesFileSource((String)vaultBootstrapConfFilename);
            this.vaultCommunicationService = new StandardHashiCorpVaultCommunicationService(new PropertySource[]{propertySource});
            this.path = Objects.requireNonNull((String)propertySource.getProperty(KEY_VALUE_PATH), String.format("%s must be specified in %s", KEY_VALUE_PATH, vaultBootstrapConfFilename));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error configuring HashiCorpVaultCommunicationService", e);
        }
    }

    protected String getSecretValue(String secretName, String keyName) {
        Map keyValues = this.vaultCommunicationService.readKeyValueSecretMap(this.path, secretName);
        return (String)keyValues.get(keyName);
    }

    void setVaultCommunicationService(HashiCorpVaultCommunicationService vaultCommunicationService) {
        this.vaultCommunicationService = vaultCommunicationService;
    }

    void setPath(String path) {
        this.path = path;
    }
}

