/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp;

import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultCommunicationService;
import org.apache.nifi.vault.hashicorp.VaultAuthenticationMethod;

public interface HashiCorpVaultClientService
extends ControllerService,
VerifiableControllerService {
    public static final AllowableValue DIRECT_PROPERTIES = new AllowableValue("direct-properties", "Direct Properties", "Use properties, including dynamic properties, configured directly in the Controller Service to configure the client");
    public static final AllowableValue PROPERTIES_FILES = new AllowableValue("properties-files", "Properties Files", "Use one or more '.properties' files to configure the client");
    public static final PropertyDescriptor CONFIGURATION_STRATEGY = new PropertyDescriptor.Builder().displayName("Configuration Strategy").name("configuration-strategy").required(true).allowableValues(new DescribedValue[]{DIRECT_PROPERTIES, PROPERTIES_FILES}).defaultValue(DIRECT_PROPERTIES.getValue()).description("Specifies the source of the configuration properties.").build();
    public static final PropertyDescriptor VAULT_URI = new PropertyDescriptor.Builder().name("vault.uri").displayName("Vault URI").description("The URI of the HashiCorp Vault server (e.g., http://localhost:8200).  Required if not specified in the Bootstrap HashiCorp Vault Configuration File.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.URI_VALIDATOR).dependsOn(CONFIGURATION_STRATEGY, new AllowableValue[]{DIRECT_PROPERTIES}).build();
    public static final PropertyDescriptor VAULT_AUTHENTICATION = new PropertyDescriptor.Builder().name("vault.authentication").displayName("Vault Authentication").description("Vault authentication method, as described in the Spring Vault Environment Configuration documentation (https://docs.spring.io/spring-vault/docs/2.3.x/reference/html/#vault.core.environment-vault-configuration).").required(true).allowableValues((Enum[])VaultAuthenticationMethod.values()).defaultValue(VaultAuthenticationMethod.TOKEN.name()).dependsOn(CONFIGURATION_STRATEGY, new AllowableValue[]{DIRECT_PROPERTIES}).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("vault.ssl.context.service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections to the HashiCorp Vault server.").required(false).identifiesControllerService(SSLContextService.class).dependsOn(CONFIGURATION_STRATEGY, new AllowableValue[]{DIRECT_PROPERTIES}).build();
    public static final PropertyDescriptor VAULT_PROPERTIES_FILES = new PropertyDescriptor.Builder().name("vault.properties.files").displayName("Vault Properties Files").description("A comma-separated list of files containing HashiCorp Vault configuration properties, as described in the Spring Vault Environment Configuration documentation (https://docs.spring.io/spring-vault/docs/2.3.x/reference/html/#vault.core.environment-vault-configuration). All of the Spring property keys and authentication-specific property keys are supported.").required(true).dependsOn(CONFIGURATION_STRATEGY, new AllowableValue[]{PROPERTIES_FILES}).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("vault.connection.timeout").displayName("Connection Timeout").description("The connection timeout for the HashiCorp Vault client").required(true).defaultValue("5 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("vault.read.timeout").displayName("Read Timeout").description("The read timeout for the HashiCorp Vault client").required(true).defaultValue("15 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();

    public HashiCorpVaultCommunicationService getHashiCorpVaultCommunicationService();
}

