/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HDFSResourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HDFSResourceHelper.class);

    private HDFSResourceHelper() {
    }

    public static void closeFileSystem(FileSystem fileSystem) {
        try {
            HDFSResourceHelper.interruptStatisticsThread(fileSystem);
        }
        catch (Exception e) {
            LOGGER.warn("Error stopping FileSystem statistics thread", (Throwable)e);
            LOGGER.debug("", (Throwable)e);
        }
        finally {
            if (fileSystem != null) {
                try {
                    fileSystem.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error close FileSystem", (Throwable)e);
                }
            }
        }
    }

    private static void interruptStatisticsThread(FileSystem fileSystem) throws NoSuchFieldException, IllegalAccessException {
        Field statsField = FileSystem.class.getDeclaredField("statistics");
        statsField.setAccessible(true);
        Object statsObj = statsField.get(fileSystem);
        if (statsObj instanceof FileSystem.Statistics) {
            FileSystem.Statistics statistics = (FileSystem.Statistics)statsObj;
            Field statsThreadField = statistics.getClass().getDeclaredField("STATS_DATA_CLEANER");
            statsThreadField.setAccessible(true);
            Object statsThreadObj = statsThreadField.get(statistics);
            if (statsThreadObj instanceof Thread) {
                Thread statsThread = (Thread)statsThreadObj;
                try {
                    statsThread.interrupt();
                }
                catch (Exception e) {
                    LOGGER.warn("Error interrupting thread", (Throwable)e);
                }
            }
        }
    }
}

