/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.util.ArrayList;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.nifi.components.AllowableValue;

public enum CompressionType {
    NONE("No compression"),
    DEFAULT("Default ZLIB compression"),
    BZIP("BZIP compression"),
    GZIP("GZIP compression"),
    LZ4("LZ4 compression"),
    LZO("LZO compression - it assumes LD_LIBRARY_PATH has been set and jar is available"),
    SNAPPY("Snappy compression"),
    AUTOMATIC("Will attempt to automatically detect the compression codec.");

    private final String description;

    private CompressionType(String description) {
        this.description = description;
    }

    private String getDescription() {
        return this.description;
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "NONE";
            case 1 -> DefaultCodec.class.getName();
            case 2 -> BZip2Codec.class.getName();
            case 3 -> GzipCodec.class.getName();
            case 4 -> Lz4Codec.class.getName();
            case 5 -> "com.hadoop.compression.lzo.LzoCodec";
            case 6 -> SnappyCodec.class.getName();
            case 7 -> "Automatically Detected";
        };
    }

    public static AllowableValue[] allowableValues() {
        ArrayList<AllowableValue> values = new ArrayList<AllowableValue>();
        for (CompressionType type : CompressionType.values()) {
            values.add(new AllowableValue(type.name(), type.name(), type.getDescription()));
        }
        return values.toArray(new AllowableValue[values.size()]);
    }
}

