/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.net.SocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.hadoop.CompressionType;
import org.apache.nifi.processors.hadoop.ExtendedConfiguration;
import org.apache.nifi.processors.hadoop.HDFSResourceHelper;
import org.apache.nifi.processors.hadoop.HdfsResources;
import org.apache.nifi.security.krb.KerberosUser;
import org.ietf.jgss.GSSException;

@RequiresInstanceClassLoading(cloneAncestorResources=true)
public abstract class AbstractHadoopProcessor
extends AbstractProcessor
implements ClassloaderIsolationKeyProvider {
    private static final String DENY_LFS_ACCESS = "NIFI_HDFS_DENY_LOCAL_FILE_SYSTEM_ACCESS";
    private static final String DENY_LFS_EXPLANATION = String.format("LFS Access Denied according to Environment Variable [%s]", "NIFI_HDFS_DENY_LOCAL_FILE_SYSTEM_ACCESS");
    private static final Pattern LOCAL_FILE_SYSTEM_URI = Pattern.compile("^file:.*");
    private static final String NORMALIZE_ERROR_WITH_PROPERTY = "The filesystem component of the URI configured in the '{}' property ({}) does not match the filesystem URI from the Hadoop configuration file ({}) and will be ignored.";
    private static final String NORMALIZE_ERROR_WITHOUT_PROPERTY = "The filesystem component of the URI configured ({}) does not match the filesystem URI from the Hadoop configuration file ({}) and will be ignored.";
    public static final PropertyDescriptor HADOOP_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("Hadoop Configuration Resources").description("A file or comma separated list of files which contains the Hadoop file system configuration. Without this, Hadoop will search the classpath for a 'core-site.xml' and 'hdfs-site.xml' file or will revert to a default configuration. To use swebhdfs, see 'Additional Details' section of PutHDFS's documentation.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").description("The HDFS directory from which files should be read").required(true).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor COMPRESSION_CODEC = new PropertyDescriptor.Builder().name("Compression codec").required(true).allowableValues((DescribedValue[])CompressionType.allowableValues()).defaultValue(CompressionType.NONE.toString()).build();
    public static final PropertyDescriptor ADDITIONAL_CLASSPATH_RESOURCES = new PropertyDescriptor.Builder().name("Additional Classpath Resources").description("A comma-separated list of paths to files and/or directories that will be added to the classpath and used for loading native libraries. When specifying a directory, all files with in the directory will be added to the classpath, but further sub-directories will not be included.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Specifies the Kerberos User Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosUserService.class).required(false).build();
    public static final String ABSOLUTE_HDFS_PATH_ATTRIBUTE = "absolute.hdfs.path";
    public static final String HADOOP_FILE_URL_ATTRIBUTE = "hadoop.file.url";
    protected static final String TARGET_HDFS_DIR_CREATED_ATTRIBUTE = "target.dir.created";
    private static final Object RESOURCES_LOCK = new Object();
    private static final HdfsResources EMPTY_HDFS_RESOURCES = new HdfsResources(null, null, null, null);
    protected List<PropertyDescriptor> properties;
    final AtomicReference<HdfsResources> hdfsResources = new AtomicReference();
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        this.hdfsResources.set(EMPTY_HDFS_RESOURCES);
        this.properties = List.of(HADOOP_CONFIGURATION_RESOURCES, KERBEROS_USER_SERVICE, ADDITIONAL_CLASSPATH_RESOURCES);
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.removeProperty("Kerberos Principal");
        config.removeProperty("Kerberos Password");
        config.removeProperty("Kerberos Keytab");
        config.removeProperty("kerberos-credentials-service");
        config.removeProperty("Kerberos Relogin Period");
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public String getClassloaderIsolationKey(PropertyContext context) {
        class ClassloaderIsolationKeyBuilder {
            private static final String SEPARATOR = "__";
            private final StringBuilder sb = new StringBuilder();

            ClassloaderIsolationKeyBuilder(AbstractHadoopProcessor this$0) {
            }

            void add(String value) {
                if (value != null) {
                    if (this.sb.length() > 0) {
                        this.sb.append(SEPARATOR);
                    }
                    this.sb.append(value);
                }
            }

            String build() {
                return this.sb.length() > 0 ? this.sb.toString() : null;
            }
        }
        ClassloaderIsolationKeyBuilder builder = new ClassloaderIsolationKeyBuilder(this);
        builder.add(context.getProperty(HADOOP_CONFIGURATION_RESOURCES).getValue());
        builder.add(context.getProperty(ADDITIONAL_CLASSPATH_RESOURCES).getValue());
        try {
            KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
            if (kerberosUserService != null) {
                KerberosUser kerberosUser = kerberosUserService.createKerberosUser();
                builder.add(kerberosUser.getPrincipal());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return builder.build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List<String> locations = this.getConfigLocations((PropertyContext)validationContext);
        if (locations.isEmpty()) {
            return results;
        }
        try {
            Configuration conf = this.getHadoopConfigurationForValidation(locations);
            results.addAll(this.validateFileSystem(conf));
        }
        catch (IOException e) {
            results.add(new ValidationResult.Builder().valid(false).subject("Hadoop Configuration Resources").explanation("Could not load Hadoop Configuration resources due to: " + String.valueOf(e)).build());
        }
        return results;
    }

    protected Collection<ValidationResult> validateFileSystem(Configuration configuration) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (this.isFileSystemAccessDenied(FileSystem.getDefaultUri((Configuration)configuration))) {
            results.add(new ValidationResult.Builder().valid(false).subject("Hadoop File System").explanation(DENY_LFS_EXPLANATION).build());
        }
        return results;
    }

    protected Configuration getHadoopConfigurationForValidation(List<String> locations) throws IOException {
        ValidationResources resources = this.validationResourceHolder.get();
        if (resources == null || !locations.equals(resources.getConfigLocations())) {
            this.getLogger().debug("Reloading validation resources");
            ExtendedConfiguration config = new ExtendedConfiguration(this.getLogger());
            config.setClassLoader(Thread.currentThread().getContextClassLoader());
            resources = new ValidationResources(locations, AbstractHadoopProcessor.getConfigurationFromResources(config, locations));
            this.validationResourceHolder.set(resources);
        }
        return resources.getConfiguration();
    }

    @OnScheduled
    public final void abstractOnScheduled(ProcessContext context) throws IOException {
        try {
            HdfsResources resources = this.hdfsResources.get();
            if (resources.getConfiguration() == null) {
                resources = this.resetHDFSResources(this.getConfigLocations((PropertyContext)context), context);
                this.hdfsResources.set(resources);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("HDFS Configuration failed", (Throwable)ex);
            this.hdfsResources.set(EMPTY_HDFS_RESOURCES);
            throw ex;
        }
    }

    protected List<String> getConfigLocations(PropertyContext context) {
        ResourceReferences configResources = context.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().asResources();
        List locations = configResources.asLocations();
        return locations;
    }

    @OnStopped
    public final void abstractOnStopped() {
        HdfsResources resources = this.hdfsResources.get();
        if (resources != null) {
            FileSystem fileSystem = resources.getFileSystem();
            HDFSResourceHelper.closeFileSystem(fileSystem);
        }
        this.hdfsResources.set(EMPTY_HDFS_RESOURCES);
    }

    private static Configuration getConfigurationFromResources(Configuration config, List<String> locations) throws IOException {
        boolean foundResources;
        boolean bl = foundResources = !locations.isEmpty();
        if (foundResources) {
            for (String resource : locations) {
                config.addResource(new Path(resource.trim()));
            }
        } else {
            String configStr = config.toString();
            for (String resource : configStr.substring(configStr.indexOf(":") + 1).split(",")) {
                if (resource.contains("default") || config.getResource(resource.trim()) == null) continue;
                foundResources = true;
                break;
            }
        }
        if (!foundResources) {
            throw new IOException("Could not find any of the " + HADOOP_CONFIGURATION_RESOURCES.getName() + " on the classpath");
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsResources resetHDFSResources(List<String> resourceLocations, ProcessContext context) throws IOException {
        FileSystem fs;
        UserGroupInformation ugi;
        KerberosUser kerberosUser;
        ExtendedConfiguration config = new ExtendedConfiguration(this.getLogger());
        config.setClassLoader(Thread.currentThread().getContextClassLoader());
        AbstractHadoopProcessor.getConfigurationFromResources(config, resourceLocations);
        this.preProcessConfiguration(config, context);
        this.checkHdfsUriForTimeout(config);
        String disableCacheName = String.format("fs.%s.impl.disable.cache", FileSystem.getDefaultUri((Configuration)config).getScheme());
        config.set(disableCacheName, "true");
        Object object = RESOURCES_LOCK;
        synchronized (object) {
            if (SecurityUtil.isSecurityEnabled(config)) {
                kerberosUser = this.getKerberosUser(context);
                ugi = SecurityUtil.getUgiForKerberosUser(config, kerberosUser);
            } else {
                config.set("ipc.client.fallback-to-simple-auth-allowed", "true");
                config.set("hadoop.security.authentication", "simple");
                ugi = SecurityUtil.loginSimple(config);
                kerberosUser = null;
            }
            fs = this.getFileSystemAsUser(config, ugi);
        }
        this.getLogger().debug("resetHDFSResources UGI [{}], KerberosUser [{}]", new Object[]{ugi, kerberosUser});
        Path workingDir = fs.getWorkingDirectory();
        this.getLogger().info("Initialized a new HDFS File System with working dir: {} default block size: {} default replication: {} config: {}", new Object[]{workingDir, fs.getDefaultBlockSize(workingDir), fs.getDefaultReplication(workingDir), config.toString()});
        return new HdfsResources(config, fs, ugi, kerberosUser);
    }

    private KerberosUser getKerberosUser(ProcessContext context) {
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosUserService != null) {
            return kerberosUserService.createKerberosUser();
        }
        throw new IllegalStateException("Unable to authenticate with Kerberos, no keytab or password was provided");
    }

    protected void preProcessConfiguration(Configuration config, ProcessContext context) {
    }

    protected FileSystem getFileSystem(Configuration config) throws IOException {
        return FileSystem.get((Configuration)config);
    }

    protected FileSystem getFileSystemAsUser(Configuration config, UserGroupInformation ugi) throws IOException {
        try {
            return (FileSystem)ugi.doAs(() -> FileSystem.get((Configuration)config));
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to create file system: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHdfsUriForTimeout(Configuration config) throws IOException {
        URI hdfsUri = FileSystem.getDefaultUri((Configuration)config);
        String address = hdfsUri.getAuthority();
        int port = hdfsUri.getPort();
        if (address == null || address.isEmpty() || port < 0) {
            return;
        }
        InetSocketAddress namenode = NetUtils.createSocketAddr((String)address, (int)port);
        SocketFactory socketFactory = NetUtils.getDefaultSocketFactory((Configuration)config);
        Socket socket = null;
        try {
            socket = socketFactory.createSocket();
            NetUtils.connect((Socket)socket, (SocketAddress)namenode, (int)1000);
        }
        finally {
            IOUtils.closeQuietly((Socket)socket);
        }
    }

    protected CompressionCodec getCompressionCodec(ProcessContext context, Configuration configuration) {
        CompressionCodec codec = null;
        if (context.getProperty(COMPRESSION_CODEC).isSet()) {
            String compressionClassname = CompressionType.valueOf(context.getProperty(COMPRESSION_CODEC).getValue()).toString();
            CompressionCodecFactory ccf = new CompressionCodecFactory(configuration);
            codec = ccf.getCodecByClassName(compressionClassname);
        }
        return codec;
    }

    public static String getPathDifference(Path root, Path child) {
        String name;
        int depthDiff = child.depth() - root.depth();
        if (depthDiff <= 1) {
            return "";
        }
        String lastRoot = root.getName();
        Path childsParent = child.getParent();
        StringBuilder builder = new StringBuilder();
        builder.append(childsParent.getName());
        for (int i = depthDiff - 3; !(i < 0 || (name = (childsParent = childsParent.getParent()).getName()).equals(lastRoot) && childsParent.toString().endsWith(root.toString())); --i) {
            builder.insert(0, "/").insert(0, name);
        }
        return builder.toString();
    }

    protected Configuration getConfiguration() {
        return this.hdfsResources.get().getConfiguration();
    }

    protected FileSystem getFileSystem() {
        return this.hdfsResources.get().getFileSystem();
    }

    protected UserGroupInformation getUserGroupInformation() {
        this.getLogger().trace("getting UGI instance");
        SecurityUtil.checkTGTAndRelogin(this.getLogger(), this.hdfsResources.get().getKerberosUser());
        return this.hdfsResources.get().getUserGroupInformation();
    }

    boolean isLocalFileSystemAccessDenied() {
        return Boolean.parseBoolean(System.getenv(DENY_LFS_ACCESS));
    }

    protected boolean isFileSystemAccessDenied(URI fileSystemUri) {
        boolean accessDenied = this.isLocalFileSystemAccessDenied() ? LOCAL_FILE_SYSTEM_URI.matcher(fileSystemUri.toString()).matches() : false;
        return accessDenied;
    }

    protected Path getNormalizedPath(ProcessContext context, PropertyDescriptor property) {
        return this.getNormalizedPath(context, property, null);
    }

    protected Path getNormalizedPath(String rawPath) {
        return this.getNormalizedPath(rawPath, Optional.empty());
    }

    protected Path getNormalizedPath(ProcessContext context, PropertyDescriptor property, FlowFile flowFile) {
        String propertyValue = context.getProperty(property).evaluateAttributeExpressions(flowFile).getValue();
        return this.getNormalizedPath(propertyValue, Optional.of(property.getDisplayName()));
    }

    private Path getNormalizedPath(String rawPath, Optional<String> propertyName) {
        String path;
        URI uri = new Path(rawPath).toUri();
        URI fileSystemUri = this.getFileSystem().getUri();
        if (uri.getScheme() != null) {
            if (!uri.getScheme().equals(fileSystemUri.getScheme()) || uri.getAuthority() != null && !uri.getAuthority().equals(fileSystemUri.getAuthority())) {
                if (propertyName.isPresent()) {
                    this.getLogger().warn(NORMALIZE_ERROR_WITH_PROPERTY, new Object[]{propertyName, uri, fileSystemUri});
                } else {
                    this.getLogger().warn(NORMALIZE_ERROR_WITHOUT_PROPERTY, new Object[]{uri, fileSystemUri});
                }
            }
            path = uri.getPath();
        } else {
            path = rawPath;
        }
        return new Path(path.replaceAll("/+", "/"));
    }

    protected <T extends Throwable> Optional<T> findCause(Throwable t, Class<T> expectedCauseType, Predicate<T> causePredicate) {
        Stream causalChain = Throwables.getCausalChain((Throwable)t).stream();
        return causalChain.filter(expectedCauseType::isInstance).map(expectedCauseType::cast).filter(causePredicate).findFirst();
    }

    protected boolean handleAuthErrors(Throwable t, ProcessSession session, ProcessContext context, BiConsumer<ProcessSession, ProcessContext> sessionHandler) {
        Optional<GSSException> causeOptional = this.findCause(t, GSSException.class, gsse -> 13 == gsse.getMajor());
        if (causeOptional.isPresent()) {
            this.getLogger().error("An error occurred while connecting to HDFS. Rolling back session and, and resetting HDFS resources", (Throwable)causeOptional.get());
            try {
                this.hdfsResources.set(this.resetHDFSResources(this.getConfigLocations((PropertyContext)context), context));
            }
            catch (IOException ioe) {
                this.getLogger().error("An error occurred resetting HDFS resources, you may need to restart the processor.");
            }
            sessionHandler.accept(session, context);
            return true;
        }
        return false;
    }

    protected static class ValidationResources {
        private final List<String> configLocations;
        private final Configuration configuration;

        public ValidationResources(List<String> configLocations, Configuration configuration) {
            this.configLocations = configLocations;
            this.configuration = configuration;
        }

        public List<String> getConfigLocations() {
            return this.configLocations;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

