/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslPlainServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.hadoop.CompressionType;
import org.apache.nifi.processors.hadoop.HadoopValidators;

@RequiresInstanceClassLoading(cloneAncestorResources=true)
public abstract class AbstractHadoopProcessor
extends AbstractProcessor {
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    public static final PropertyDescriptor HADOOP_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("Hadoop Configuration Resources").description("A file or comma separated list of files which contains the Hadoop file system configuration. Without this, Hadoop will search the classpath for a 'core-site.xml' and 'hdfs-site.xml' file or will revert to a default configuration. To use swebhdfs, see 'Additional Details' section of PutHDFS's documentation.").required(false).addValidator(HadoopValidators.ONE_OR_MORE_FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").description("The HDFS directory from which files should be read").required(true).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor COMPRESSION_CODEC = new PropertyDescriptor.Builder().name("Compression codec").required(true).allowableValues(CompressionType.allowableValues()).defaultValue(CompressionType.NONE.toString()).build();
    public static final PropertyDescriptor KERBEROS_RELOGIN_PERIOD = new PropertyDescriptor.Builder().name("Kerberos Relogin Period").required(false).description("Period of time which should pass before attempting a kerberos relogin.\n\nThis property has been deprecated, and has no effect on processing. Relogins now occur automatically.").defaultValue("4 hours").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor ADDITIONAL_CLASSPATH_RESOURCES = new PropertyDescriptor.Builder().name("Additional Classpath Resources").description("A comma-separated list of paths to files and/or directories that will be added to the classpath. When specifying a directory, all files with in the directory will be added to the classpath, but further sub-directories will not be included.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamicallyModifiesClasspath(true).build();
    static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    public static final String ABSOLUTE_HDFS_PATH_ATTRIBUTE = "absolute.hdfs.path";
    private static final Object RESOURCES_LOCK = new Object();
    protected KerberosProperties kerberosProperties;
    protected List<PropertyDescriptor> properties;
    private volatile File kerberosConfigFile = null;
    private final AtomicReference<HdfsResources> hdfsResources = new AtomicReference();
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        this.hdfsResources.set(new HdfsResources(null, null, null));
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosProperties = this.getKerberosProperties(this.kerberosConfigFile);
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(HADOOP_CONFIGURATION_RESOURCES);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(this.kerberosProperties.getKerberosPrincipal());
        props.add(this.kerberosProperties.getKerberosKeytab());
        props.add(KERBEROS_RELOGIN_PERIOD);
        props.add(ADDITIONAL_CLASSPATH_RESOURCES);
        this.properties = Collections.unmodifiableList(props);
    }

    protected KerberosProperties getKerberosProperties(File kerberosConfigFile) {
        return new KerberosProperties(kerberosConfigFile);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String allowExplicitKeytabVariable;
        String resolvedKeytab;
        String resolvedPrincipal;
        String configResources = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        String explicitPrincipal = validationContext.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
        String explicitKeytab = validationContext.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            resolvedPrincipal = explicitPrincipal;
            resolvedKeytab = explicitKeytab;
        } else {
            resolvedPrincipal = credentialsService.getPrincipal();
            resolvedKeytab = credentialsService.getKeytab();
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (StringUtils.isBlank((String)configResources)) {
            return results;
        }
        try {
            ValidationResources resources = this.validationResourceHolder.get();
            if (resources == null || !configResources.equals(resources.getConfigResources())) {
                this.getLogger().debug("Reloading validation resources");
                ExtendedConfiguration config = new ExtendedConfiguration(this.getLogger());
                config.setClassLoader(Thread.currentThread().getContextClassLoader());
                resources = new ValidationResources(configResources, AbstractHadoopProcessor.getConfigurationFromResources(config, configResources));
                this.validationResourceHolder.set(resources);
            }
            Configuration conf = resources.getConfiguration();
            results.addAll(KerberosProperties.validatePrincipalAndKeytab(((Object)((Object)this)).getClass().getSimpleName(), conf, resolvedPrincipal, resolvedKeytab, this.getLogger()));
        }
        catch (IOException e) {
            results.add(new ValidationResult.Builder().valid(false).subject("Hadoop Configuration Resources").explanation("Could not load Hadoop Configuration resources due to: " + e).build());
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitKeytab != null)) {
            results.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Cannot specify both a Kerberos Credentials Service and a principal/keytab").build());
        }
        if ("false".equalsIgnoreCase(allowExplicitKeytabVariable = System.getenv(ALLOW_EXPLICIT_KEYTAB)) && (explicitPrincipal != null || explicitKeytab != null)) {
            results.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("The 'NIFI_ALLOW_EXPLICIT_KEYTAB' system environment variable is configured to forbid explicitly configuring principal/keytab in processors. The Kerberos Credentials Service should be used instead of setting the Kerberos Keytab or Kerberos Principal property.").build());
        }
        return results;
    }

    @OnScheduled
    public final void abstractOnScheduled(ProcessContext context) throws IOException {
        try {
            HdfsResources resources = this.hdfsResources.get();
            if (resources.getConfiguration() == null) {
                String configResources = context.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
                resources = this.resetHDFSResources(configResources, context);
                this.hdfsResources.set(resources);
            }
        }
        catch (IOException ex) {
            this.getLogger().error("HDFS Configuration error - {}", new Object[]{ex});
            this.hdfsResources.set(new HdfsResources(null, null, null));
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public final void abstractOnStopped() {
        HdfsResources resources = this.hdfsResources.get();
        if (resources != null) {
            FileSystem fileSystem = resources.getFileSystem();
            try {
                this.interruptStatisticsThread(fileSystem);
            }
            catch (Exception e) {
                this.getLogger().warn("Error stopping FileSystem statistics thread: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (fileSystem != null) {
                    try {
                        fileSystem.close();
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Error close FileSystem: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            UserGroupInformation.setConfiguration((Configuration)new Configuration());
            Configuration configuration = resources.getConfiguration();
            configuration.setClassLoader(null);
            SaslPlainServer.SecurityProvider saslProvider = new SaslPlainServer.SecurityProvider();
            Security.removeProvider(saslProvider.getName());
        }
        this.hdfsResources.set(new HdfsResources(null, null, null));
    }

    private void interruptStatisticsThread(FileSystem fileSystem) throws NoSuchFieldException, IllegalAccessException {
        Field statsField = FileSystem.class.getDeclaredField("statistics");
        statsField.setAccessible(true);
        Object statsObj = statsField.get(fileSystem);
        if (statsObj != null && statsObj instanceof FileSystem.Statistics) {
            FileSystem.Statistics statistics = (FileSystem.Statistics)statsObj;
            Field statsThreadField = statistics.getClass().getDeclaredField("STATS_DATA_CLEANER");
            statsThreadField.setAccessible(true);
            Object statsThreadObj = statsThreadField.get(statistics);
            if (statsThreadObj != null && statsThreadObj instanceof Thread) {
                Thread statsThread = (Thread)statsThreadObj;
                try {
                    statsThread.interrupt();
                }
                catch (Exception e) {
                    this.getLogger().warn("Error interrupting thread: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static Configuration getConfigurationFromResources(Configuration config, String configResources) throws IOException {
        boolean foundResources = false;
        if (null != configResources) {
            String[] resources;
            for (String resource : resources = configResources.split(",")) {
                config.addResource(new Path(resource.trim()));
                foundResources = true;
            }
        }
        if (!foundResources) {
            String configStr = config.toString();
            for (String resource : configStr.substring(configStr.indexOf(":") + 1).split(",")) {
                if (resource.contains("default") || config.getResource(resource.trim()) == null) continue;
                foundResources = true;
                break;
            }
        }
        if (!foundResources) {
            throw new IOException("Could not find any of the " + HADOOP_CONFIGURATION_RESOURCES.getName() + " on the classpath");
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsResources resetHDFSResources(String configResources, ProcessContext context) throws IOException {
        FileSystem fs;
        UserGroupInformation ugi;
        ExtendedConfiguration config = new ExtendedConfiguration(this.getLogger());
        config.setClassLoader(Thread.currentThread().getContextClassLoader());
        AbstractHadoopProcessor.getConfigurationFromResources(config, configResources);
        this.preProcessConfiguration(config, context);
        this.checkHdfsUriForTimeout(config);
        String disableCacheName = String.format("fs.%s.impl.disable.cache", FileSystem.getDefaultUri((Configuration)config).getScheme());
        config.set(disableCacheName, "true");
        Object object = RESOURCES_LOCK;
        synchronized (object) {
            if (SecurityUtil.isSecurityEnabled(config)) {
                String principal = context.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
                String keyTab = context.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
                KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
                if (credentialsService != null) {
                    principal = credentialsService.getPrincipal();
                    keyTab = credentialsService.getKeytab();
                }
                ugi = SecurityUtil.loginKerberos(config, principal, keyTab);
                fs = this.getFileSystemAsUser(config, ugi);
            } else {
                config.set("ipc.client.fallback-to-simple-auth-allowed", "true");
                config.set("hadoop.security.authentication", "simple");
                ugi = SecurityUtil.loginSimple(config);
                fs = this.getFileSystemAsUser(config, ugi);
            }
        }
        this.getLogger().debug("resetHDFSResources UGI {}", new Object[]{ugi});
        Path workingDir = fs.getWorkingDirectory();
        this.getLogger().info("Initialized a new HDFS File System with working dir: {} default block size: {} default replication: {} config: {}", new Object[]{workingDir, fs.getDefaultBlockSize(workingDir), fs.getDefaultReplication(workingDir), config.toString()});
        return new HdfsResources(config, fs, ugi);
    }

    protected void preProcessConfiguration(Configuration config, ProcessContext context) {
    }

    protected FileSystem getFileSystem(Configuration config) throws IOException {
        return FileSystem.get((Configuration)config);
    }

    protected FileSystem getFileSystemAsUser(final Configuration config, UserGroupInformation ugi) throws IOException {
        try {
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)config);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException("Unable to create file system: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHdfsUriForTimeout(Configuration config) throws IOException {
        URI hdfsUri = FileSystem.getDefaultUri((Configuration)config);
        String address = hdfsUri.getAuthority();
        int port = hdfsUri.getPort();
        if (address == null || address.isEmpty() || port < 0) {
            return;
        }
        InetSocketAddress namenode = NetUtils.createSocketAddr((String)address, (int)port);
        SocketFactory socketFactory = NetUtils.getDefaultSocketFactory((Configuration)config);
        Socket socket = null;
        try {
            socket = socketFactory.createSocket();
            NetUtils.connect((Socket)socket, (SocketAddress)namenode, (int)1000);
        }
        finally {
            IOUtils.closeQuietly((Socket)socket);
        }
    }

    protected CompressionCodec getCompressionCodec(ProcessContext context, Configuration configuration) {
        CompressionCodec codec = null;
        if (context.getProperty(COMPRESSION_CODEC).isSet()) {
            String compressionClassname = CompressionType.valueOf(context.getProperty(COMPRESSION_CODEC).getValue()).toString();
            CompressionCodecFactory ccf = new CompressionCodecFactory(configuration);
            codec = ccf.getCodecByClassName(compressionClassname);
        }
        return codec;
    }

    public static String getPathDifference(Path root, Path child) {
        String name;
        int depthDiff = child.depth() - root.depth();
        if (depthDiff <= 1) {
            return "".intern();
        }
        String lastRoot = root.getName();
        Path childsParent = child.getParent();
        StringBuilder builder = new StringBuilder();
        builder.append(childsParent.getName());
        for (int i = depthDiff - 3; !(i < 0 || (name = (childsParent = childsParent.getParent()).getName()).equals(lastRoot) && childsParent.toString().endsWith(root.toString())); --i) {
            builder.insert(0, "/").insert(0, name);
        }
        return builder.toString();
    }

    protected Configuration getConfiguration() {
        return this.hdfsResources.get().getConfiguration();
    }

    protected FileSystem getFileSystem() {
        return this.hdfsResources.get().getFileSystem();
    }

    protected UserGroupInformation getUserGroupInformation() {
        return this.hdfsResources.get().getUserGroupInformation();
    }

    static class ExtendedConfiguration
    extends Configuration {
        private final ComponentLog logger;
        private final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();

        public ExtendedConfiguration(ComponentLog logger) {
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> getClassByNameOrNull(String name) {
            Map<String, WeakReference<Class<Object>>> map;
            ClassLoader classLoader = this.getClassLoader();
            Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = this.CACHE_CLASSES;
            synchronized (map2) {
                map = this.CACHE_CLASSES.get(classLoader);
                if (map == null) {
                    map = Collections.synchronizedMap(new WeakHashMap());
                    this.CACHE_CLASSES.put(classLoader, map);
                }
            }
            Class<?> clazz = null;
            WeakReference<Class<Object>> ref = map.get(name);
            if (ref != null) {
                clazz = (Class<?>)ref.get();
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(name, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                map.put(name, new WeakReference(clazz));
                return clazz;
            }
            return clazz;
        }
    }

    protected static class ValidationResources {
        private final String configResources;
        private final Configuration configuration;

        public ValidationResources(String configResources, Configuration configuration) {
            this.configResources = configResources;
            this.configuration = configuration;
        }

        public String getConfigResources() {
            return this.configResources;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }

    protected static class HdfsResources {
        private final Configuration configuration;
        private final FileSystem fileSystem;
        private final UserGroupInformation userGroupInformation;

        public HdfsResources(Configuration configuration, FileSystem fileSystem, UserGroupInformation userGroupInformation) {
            this.configuration = configuration;
            this.fileSystem = fileSystem;
            this.userGroupInformation = userGroupInformation;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public UserGroupInformation getUserGroupInformation() {
            return this.userGroupInformation;
        }
    }
}

