/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class SecurityUtil {
    public static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    public static final String KERBEROS = "kerberos";

    public static synchronized UserGroupInformation loginKerberos(Configuration config, String principal, String keyTab) throws IOException {
        Validate.notNull((Object)config);
        Validate.notNull((Object)principal);
        Validate.notNull((Object)keyTab);
        UserGroupInformation.setConfiguration((Configuration)config);
        UserGroupInformation.loginUserFromKeytab((String)principal.trim(), (String)keyTab.trim());
        return UserGroupInformation.getCurrentUser();
    }

    public static synchronized UserGroupInformation loginSimple(Configuration config) throws IOException {
        Validate.notNull((Object)config);
        UserGroupInformation.setConfiguration((Configuration)config);
        return UserGroupInformation.getLoginUser();
    }

    public static boolean isSecurityEnabled(Configuration config) {
        Validate.notNull((Object)config);
        return KERBEROS.equalsIgnoreCase(config.get(HADOOP_SECURITY_AUTHENTICATION));
    }
}

