/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public interface HadoopValidators {
    public static final Validator UMASK_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                short shortVal = Short.parseShort(value, 8);
                if (shortVal < 0) {
                    reason = "octal umask [" + value + "] cannot be negative";
                } else if (shortVal > 511) {
                    reason = "octal umask [" + value + "] is not a valid umask";
                }
            }
            catch (NumberFormatException e) {
                reason = "[" + value + "] is not a valid short octal number";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator POSITIVE_SHORT_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String reason = null;
            try {
                short shortVal = Short.parseShort(value);
                if (shortVal <= 0) {
                    reason = "short integer must be greater than zero";
                }
            }
            catch (NumberFormatException e) {
                reason = "[" + value + "] is not a valid short integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
}

