/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.hadoop.KerberosTicketRenewer;
import org.apache.nifi.logging.ComponentLog;

public class SecurityUtil {
    public static synchronized UserGroupInformation loginKerberos(Configuration config, String principal, String keyTab) throws IOException {
        Validate.notNull((Object)config);
        Validate.notNull((Object)principal);
        Validate.notNull((Object)keyTab);
        UserGroupInformation.setConfiguration((Configuration)config);
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal.trim(), (String)keyTab.trim());
    }

    public static synchronized UserGroupInformation loginSimple(Configuration config) throws IOException {
        Validate.notNull((Object)config);
        UserGroupInformation.setConfiguration((Configuration)config);
        return UserGroupInformation.getLoginUser();
    }

    public static boolean isSecurityEnabled(Configuration config) {
        Validate.notNull((Object)config);
        return "kerberos".equalsIgnoreCase(config.get("hadoop.security.authentication"));
    }

    public static KerberosTicketRenewer startTicketRenewalThread(String id, UserGroupInformation ugi, long renewalPeriod, ComponentLog logger) {
        KerberosTicketRenewer renewer = new KerberosTicketRenewer(ugi, renewalPeriod, logger);
        Thread t = new Thread(renewer);
        t.setName("Kerberos Ticket Renewal [" + id + "]");
        t.start();
        return renewer;
    }
}

