/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.io.IOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.logging.ComponentLog;

public class KerberosTicketRenewer
implements Runnable {
    private final UserGroupInformation ugi;
    private final long renewalPeriod;
    private final ComponentLog logger;
    private volatile boolean stopped = false;

    public KerberosTicketRenewer(UserGroupInformation ugi, long renewalPeriod, ComponentLog logger) {
        this.ugi = ugi;
        this.renewalPeriod = renewalPeriod;
        this.logger = logger;
    }

    @Override
    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            try {
                this.logger.debug("Invoking renewal attempt for Kerberos ticket");
                this.ugi.checkTGTAndReloginFromKeytab();
            }
            catch (IOException e) {
                this.logger.error("Failed to renew Kerberos ticket", (Throwable)e);
            }
            try {
                Thread.sleep(this.renewalPeriod);
            }
            catch (InterruptedException e) {
                this.logger.error("Renewal thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }
}

