/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hadoop;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;

public class KerberosProperties {
    private final File kerberosConfigFile;
    private final Validator kerberosConfigValidator;
    private final PropertyDescriptor kerberosPrincipal;
    private final PropertyDescriptor kerberosKeytab;

    public KerberosProperties(final File kerberosConfigFile) {
        this.kerberosConfigFile = kerberosConfigFile;
        this.kerberosConfigValidator = new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (kerberosConfigFile == null) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("you are missing the nifi.kerberos.krb5.file property which must be set in order to use Kerberos").build();
                }
                if (!kerberosConfigFile.canRead()) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(String.format("unable to read Kerberos config [%s], please make sure the path is valid and nifi has adequate permissions", kerberosConfigFile.getAbsoluteFile())).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
        };
        this.kerberosPrincipal = new PropertyDescriptor.Builder().name("Kerberos Principal").required(false).description("Kerberos principal to authenticate as. Requires nifi.kerberos.krb5.file to be set in your nifi.properties").addValidator(this.kerberosConfigValidator).build();
        this.kerberosKeytab = new PropertyDescriptor.Builder().name("Kerberos Keytab").required(false).description("Kerberos keytab associated with the principal. Requires nifi.kerberos.krb5.file to be set in your nifi.properties").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).addValidator(this.kerberosConfigValidator).build();
    }

    public File getKerberosConfigFile() {
        return this.kerberosConfigFile;
    }

    public Validator getKerberosConfigValidator() {
        return this.kerberosConfigValidator;
    }

    public PropertyDescriptor getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public PropertyDescriptor getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    public static List<ValidationResult> validatePrincipalAndKeytab(String subject, Configuration config, String principal, String keytab, ComponentLog logger) {
        boolean blankKeytab;
        boolean blankPrincipal;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean isSecurityEnabled = SecurityUtil.isSecurityEnabled(config);
        boolean bl = blankPrincipal = principal == null || principal.isEmpty();
        if (isSecurityEnabled && blankPrincipal) {
            results.add(new ValidationResult.Builder().valid(false).subject(subject).explanation("Kerberos Principal must be provided when using a secure configuration").build());
        }
        boolean bl2 = blankKeytab = keytab == null || keytab.isEmpty();
        if (isSecurityEnabled && blankKeytab) {
            results.add(new ValidationResult.Builder().valid(false).subject(subject).explanation("Kerberos Keytab must be provided when using a secure configuration").build());
        }
        if (!(isSecurityEnabled || blankPrincipal && blankKeytab)) {
            logger.warn("Configuration does not have security enabled, Keytab and Principal will be ignored");
        }
        return results;
    }
}

