/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.nar.NarProviderInitializationContext;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiProperties;

public class PropertyBasedNarProviderInitializationContext
implements NarProviderInitializationContext {
    private static Set<String> GUARDED_PROPERTIES = new HashSet<String>(Arrays.asList("implementation"));
    static final String BASIC_PREFIX = "nifi.nar.library.provider.";
    private final Map<String, String> properties;
    private final SSLContext sslContext;
    private final String name;

    public PropertyBasedNarProviderInitializationContext(NiFiProperties properties, String name) throws TlsException {
        this.properties = this.extractProperties(properties, name);
        this.sslContext = this.createSSLContext(properties);
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SSLContext getNiFiSSLContext() {
        return this.sslContext;
    }

    private Map<String, String> extractProperties(NiFiProperties properties, String name) {
        String prefix = BASIC_PREFIX + name + ".";
        Map candidates = properties.getPropertiesWithPrefix(prefix);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : candidates.entrySet()) {
            String parameterKey = ((String)entry.getKey()).substring(prefix.length());
            if (parameterKey.isEmpty() || GUARDED_PROPERTIES.contains(parameterKey)) continue;
            result.put(parameterKey, (String)entry.getValue());
        }
        return result;
    }

    private SSLContext createSSLContext(NiFiProperties properties) throws TlsException {
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)properties);
        return SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
    }
}

