/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarAutoLoaderTask;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.nar.NarProvider;
import org.apache.nifi.nar.NarProviderInitializationContext;
import org.apache.nifi.nar.NarProviderTask;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.nar.PropertyBasedNarProviderInitializationContext;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FileUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoLoader.class);
    private static final String NAR_PROVIDER_PREFIX = "nifi.nar.library.provider.";
    private static final String IMPLEMENTATION_PROPERTY = "implementation";
    private static final long POLL_INTERVAL_MS = 5000L;
    private static final long POLL_INTERVAL_NAR_PROVIDER_MS = 300000L;
    private final NiFiProperties properties;
    private final NarLoader narLoader;
    private final ExtensionManager extensionManager;
    private volatile Set<NarProviderTask> narProviderTasks;
    private volatile NarAutoLoaderTask narAutoLoaderTask;
    private volatile boolean started = false;

    public NarAutoLoader(NiFiProperties properties, NarLoader narLoader, ExtensionManager extensionManager) {
        this.properties = Objects.requireNonNull(properties);
        this.narLoader = Objects.requireNonNull(narLoader);
        this.extensionManager = Objects.requireNonNull(extensionManager);
    }

    public synchronized void start() throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException, TlsException {
        if (this.started) {
            return;
        }
        File autoLoadDir = this.properties.getNarAutoLoadDirectory();
        FileUtils.ensureDirectoryExistAndCanRead((File)autoLoadDir);
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path autoLoadPath = autoLoadDir.toPath();
        autoLoadPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        this.narAutoLoaderTask = new NarAutoLoaderTask.Builder().autoLoadPath(autoLoadPath).watchService(watcher).pollIntervalMillis(5000L).narLoader(this.narLoader).build();
        LOGGER.info("Starting NAR Auto-Loader for directory {} ...", new Object[]{autoLoadPath});
        Thread autoLoaderThread = new Thread(this.narAutoLoaderTask);
        autoLoaderThread.setName("NAR Auto-Loader");
        autoLoaderThread.setDaemon(true);
        autoLoaderThread.start();
        this.narProviderTasks = new HashSet<NarProviderTask>();
        for (String externalSourceName : this.properties.getDirectSubsequentTokens(NAR_PROVIDER_PREFIX)) {
            LOGGER.info("NAR Provider {} found in configuration", (Object)externalSourceName);
            PropertyBasedNarProviderInitializationContext context = new PropertyBasedNarProviderInitializationContext(this.properties, externalSourceName);
            String implementationClass = this.properties.getProperty(NAR_PROVIDER_PREFIX + externalSourceName + "." + IMPLEMENTATION_PROPERTY);
            String providerId = UUID.randomUUID().toString();
            NarProvider provider = (NarProvider)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)implementationClass, NarProvider.class, (NiFiProperties)this.properties, (String)providerId);
            provider.initialize((NarProviderInitializationContext)context);
            InstanceClassLoader instanceClassLoader = this.extensionManager.getInstanceClassLoader(providerId);
            InstanceClassLoader providerClassLoader = instanceClassLoader == null ? provider.getClass().getClassLoader() : instanceClassLoader;
            NarProviderTask task = new NarProviderTask(provider, (ClassLoader)providerClassLoader, this.properties.getNarAutoLoadDirectory(), 300000L);
            this.narProviderTasks.add(task);
            Thread providerThread = new Thread(task);
            providerThread.setName("NAR Provider Task - " + externalSourceName);
            providerThread.setDaemon(true);
            providerThread.setContextClassLoader(provider.getClass().getClassLoader());
            providerThread.start();
        }
    }

    public synchronized void stop() {
        this.started = false;
        if (this.narAutoLoaderTask != null) {
            this.narAutoLoaderTask.stop();
            this.narAutoLoaderTask = null;
        }
        if (this.narProviderTasks != null) {
            this.narProviderTasks.forEach(NarProviderTask::stop);
            this.narProviderTasks = null;
        }
        LOGGER.info("NAR Auto-Loader stopped");
    }
}

