/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.Objects;
import org.apache.nifi.nar.NarAutoLoaderTask;
import org.apache.nifi.nar.NarLoader;
import org.apache.nifi.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoLoader.class);
    private static final long POLL_INTERVAL_MS = 5000L;
    private final File autoLoadDir;
    private final NarLoader narLoader;
    private volatile NarAutoLoaderTask narAutoLoaderTask;
    private volatile boolean started = false;

    public NarAutoLoader(File autoLoadDir, NarLoader narLoader) {
        this.autoLoadDir = Objects.requireNonNull(autoLoadDir);
        this.narLoader = Objects.requireNonNull(narLoader);
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        FileUtils.ensureDirectoryExistAndCanRead((File)this.autoLoadDir);
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path autoLoadPath = this.autoLoadDir.toPath();
        autoLoadPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        this.narAutoLoaderTask = new NarAutoLoaderTask.Builder().autoLoadPath(autoLoadPath).watchService(watcher).pollIntervalMillis(5000L).narLoader(this.narLoader).build();
        LOGGER.info("Starting NAR Auto-Loader for directory {} ...", new Object[]{autoLoadPath});
        Thread thread = new Thread(this.narAutoLoaderTask);
        thread.setName("NAR Auto-Loader");
        thread.setDaemon(true);
        thread.start();
        LOGGER.info("NAR Auto-Loader started");
        this.started = true;
    }

    public synchronized void stop() {
        this.started = false;
        this.narAutoLoaderTask.stop();
        LOGGER.info("NAR Auto-Loader stopped");
    }
}

