/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.manager;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.components.state.annotation.StateProviderContext;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.state.ConfigParseException;
import org.apache.nifi.controller.state.StandardStateManager;
import org.apache.nifi.controller.state.StandardStateProviderInitializationContext;
import org.apache.nifi.controller.state.config.StateManagerConfiguration;
import org.apache.nifi.controller.state.config.StateProviderConfiguration;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardValidationContext;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStateManagerProvider
implements StateManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardStateManagerProvider.class);
    private static StateManagerProvider provider;
    private static NiFiProperties nifiProperties;
    private final ConcurrentMap<String, StateManager> stateManagers = new ConcurrentHashMap<String, StateManager>();
    private final StateProvider localStateProvider;
    private final StateProvider clusterStateProvider;
    private final StateProvider previousClusterStateProvider;

    public StandardStateManagerProvider(StateProvider localStateProvider, StateProvider clusterStateProvider) {
        this.localStateProvider = localStateProvider;
        this.clusterStateProvider = clusterStateProvider;
        this.previousClusterStateProvider = null;
    }

    private StandardStateManagerProvider(StateProvider localStateProvider, StateProvider clusterStateProvider, StateProvider previousClusterStateProvider) {
        this.localStateProvider = localStateProvider;
        this.clusterStateProvider = clusterStateProvider;
        this.previousClusterStateProvider = previousClusterStateProvider;
    }

    protected StateProvider getLocalStateProvider() {
        return this.localStateProvider;
    }

    protected StateProvider getClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public static synchronized StateManagerProvider create(NiFiProperties properties, SSLContext sslContext, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws ConfigParseException, IOException {
        StateProvider previousClusterProvider;
        StateProvider clusterProvider;
        nifiProperties = properties;
        if (provider != null) {
            return provider;
        }
        StateProvider localProvider = StandardStateManagerProvider.createLocalStateProvider(properties, sslContext, extensionManager, parameterLookup);
        if (properties.isNode()) {
            clusterProvider = StandardStateManagerProvider.createClusteredStateProvider(properties, sslContext, extensionManager, parameterLookup);
            previousClusterProvider = StandardStateManagerProvider.getPreviousClusteredStateProvider(properties, sslContext, extensionManager, parameterLookup);
        } else {
            clusterProvider = null;
            previousClusterProvider = null;
        }
        provider = new StandardStateManagerProvider(localProvider, clusterProvider, previousClusterProvider);
        return provider;
    }

    public static synchronized void resetProvider() {
        provider = null;
    }

    private static StateProvider createLocalStateProvider(NiFiProperties properties, SSLContext sslContext, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        StateProviderConfiguration config = StandardStateManagerProvider.getProviderConfiguration(Scope.LOCAL, properties.getLocalStateProviderId(), "nifi.state.management.provider.local", configFile);
        return StandardStateManagerProvider.createStateProvider(config, sslContext, extensionManager, parameterLookup);
    }

    private static StateProvider createClusteredStateProvider(NiFiProperties properties, SSLContext sslContext, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        StateProviderConfiguration config = StandardStateManagerProvider.getProviderConfiguration(Scope.CLUSTER, properties.getClusterStateProviderId(), "nifi.state.management.provider.cluster", configFile);
        return StandardStateManagerProvider.createStateProvider(config, sslContext, extensionManager, parameterLookup);
    }

    private static StateProvider getPreviousClusteredStateProvider(NiFiProperties properties, SSLContext sslContext, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException {
        String clusterProviderPreviousId = properties.getProperty("nifi.state.management.provider.cluster.previous");
        if (clusterProviderPreviousId == null || clusterProviderPreviousId.isEmpty()) {
            return null;
        }
        File configFile = properties.getStateManagementConfigFile();
        StateProviderConfiguration config = StandardStateManagerProvider.getProviderConfiguration(Scope.CLUSTER, clusterProviderPreviousId, "nifi.state.management.provider.cluster.previous", configFile);
        StateProvider previousClusterStateProvider = StandardStateManagerProvider.createStateProvider(config, sslContext, extensionManager, parameterLookup);
        if (previousClusterStateProvider.isComponentEnumerationSupported()) {
            return previousClusterStateProvider;
        }
        throw new IllegalStateException(String.format("Previous Cluster State Provider [%s] does not support Component Enumeration", clusterProviderPreviousId));
    }

    private static void loadPreviousClusterState(StateProvider previousProvider, StateProvider currentProvider) {
        String previousProviderId = previousProvider.getIdentifier();
        String currentProviderId = currentProvider.getIdentifier();
        try {
            Collection currentStoredComponentIds = currentProvider.getStoredComponentIds();
            if (currentStoredComponentIds.isEmpty()) {
                Collection previousStoredComponentIds = previousProvider.getStoredComponentIds();
                if (previousStoredComponentIds.isEmpty()) {
                    logger.info("Cluster State not found in Previous Provider [{}]", (Object)previousProviderId);
                } else {
                    StandardStateManagerProvider.loadPreviousClusterStateComponents(previousProvider, currentProvider, previousStoredComponentIds);
                }
            } else {
                logger.info("Previous Cluster State ignored: State found in Provider [{}] for Components [{}]", (Object)currentProviderId, (Object)currentStoredComponentIds.size());
            }
        }
        catch (IOException e) {
            String message = String.format("Cluster State Component Enumeration failed from Provider [%s] to Provider [%s]", previousProviderId, currentProviderId);
            throw new UncheckedIOException(message, e);
        }
    }

    private static void loadPreviousClusterStateComponents(StateProvider previousProvider, StateProvider currentProvider, Collection<String> previousStoredComponentIds) {
        String previousProviderId = previousProvider.getIdentifier();
        String currentProviderId = currentProvider.getIdentifier();
        LinkedHashSet<String> loadedComponentIds = new LinkedHashSet<String>();
        logger.info("Cluster State found in Previous Provider [{}] for Components [{}]", (Object)previousProviderId, (Object)previousStoredComponentIds.size());
        try {
            for (String componentId : previousStoredComponentIds) {
                StateMap previousState = previousProvider.getState(componentId);
                Map state = previousState.toMap();
                currentProvider.setState(state, componentId);
                logger.info("Cluster State loaded for Component [{}] to Provider [{}]", (Object)componentId, (Object)currentProviderId);
                loadedComponentIds.add(componentId);
            }
            logger.info("Cluster State loaded from Provider [{}] to Provider [{}] for Components [{}]", new Object[]{previousProviderId, currentProviderId, previousStoredComponentIds.size()});
        }
        catch (IOException e) {
            LinkedHashSet<String> failedComponentIds = new LinkedHashSet<String>(previousStoredComponentIds);
            failedComponentIds.removeAll(loadedComponentIds);
            logger.warn("Cluster State loaded for Components {} but failed for Components [{}] from Provider [{}] to Provider [{}]", new Object[]{loadedComponentIds, failedComponentIds, previousProviderId, currentProviderId});
            String message = String.format("Cluster State load failed from Provider [%s] to Provider [%s]", previousProviderId, currentProviderId);
            throw new UncheckedIOException(message, e);
        }
    }

    private static StateProviderConfiguration getProviderConfiguration(Scope scope, String providerId, String providerIdPropertyName, File configFile) throws IOException {
        if (!configFile.exists()) {
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the State Management Configuration File " + String.valueOf(configFile) + " does not exist");
        }
        if (!configFile.canRead()) {
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the State Management Configuration File " + String.valueOf(configFile) + " cannot be read");
        }
        if (providerId == null) {
            if (scope == Scope.CLUSTER) {
                throw new IllegalStateException("Cannot create Cluster State Provider because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file. In order to run NiFi in a cluster, the " + providerIdPropertyName + " property must be configured in nifi.properties");
            }
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file");
        }
        if (providerId.trim().isEmpty()) {
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the '" + providerIdPropertyName + "' property in the NiFi Properties file has no value set. This is a required property and must reference the identifier of one of the " + String.valueOf(scope) + " elements in the State Management Configuration File (" + String.valueOf(configFile) + ")");
        }
        StateManagerConfiguration config = StateManagerConfiguration.parse(configFile);
        StateProviderConfiguration providerConfig = config.getStateProviderConfiguration(providerId);
        if (providerConfig == null) {
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but there is no " + String.valueOf(scope) + " entry in the State Management Configuration File (" + String.valueOf(configFile) + ") with this id");
        }
        if (providerConfig.getScope() != scope) {
            throw new IllegalStateException("Cannot create " + String.valueOf(scope) + " Provider because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but this ID is assigned to another  entry in the State Management Configuration File (" + String.valueOf(configFile) + "), rather than a " + String.valueOf(scope) + " entry");
        }
        return providerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider createStateProvider(StateProviderConfiguration providerConfig, SSLContext sslContext, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException {
        PropertyDescriptor descriptor;
        PropertyConfiguration configuration;
        VariableImpact variableImpact;
        ParameterTokenList references;
        StateProvider provider;
        String providerClassName = providerConfig.getClassName();
        try {
            provider = StandardStateManagerProvider.instantiateStateProvider(extensionManager, providerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create " + String.valueOf(providerConfig.getScope()) + " Provider of type " + providerClassName, e);
        }
        if (!ArrayUtils.contains((Object[])provider.getSupportedScopes(), (Object)providerConfig.getScope())) {
            throw new RuntimeException("Cannot use " + String.valueOf(providerConfig.getScope()) + " (" + providerClassName + ") as it only supports scope(s) " + ArrayUtils.toString((Object)provider.getSupportedScopes()) + " but instance is configured to use scope " + String.valueOf(providerConfig.getScope()));
        }
        ExpressionLanguageAwareParameterParser parser = new ExpressionLanguageAwareParameterParser();
        HashMap<PropertyDescriptor, PropertyValue> propertyMap = new HashMap<PropertyDescriptor, PropertyValue>();
        HashMap<PropertyDescriptor, PropertyConfiguration> propertyStringMap = new HashMap<PropertyDescriptor, PropertyConfiguration>();
        StandardResourceReferenceFactory resourceReferenceFactory = new StandardResourceReferenceFactory();
        for (PropertyDescriptor propertyDescriptor : provider.getPropertyDescriptors()) {
            StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)resourceReferenceFactory, propertyDescriptor);
            propertyMap.put(propertyDescriptor, (PropertyValue)new StandardPropertyValue((ResourceContext)resourceContext, propertyDescriptor.getDefaultValue(), null, parameterLookup));
            references = parser.parseTokens(propertyDescriptor.getDefaultValue());
            variableImpact = Query.prepare((String)propertyDescriptor.getDefaultValue()).getVariableImpact();
            configuration = new PropertyConfiguration(propertyDescriptor.getDefaultValue(), references, references.toReferenceList(), variableImpact);
            propertyStringMap.put(propertyDescriptor, configuration);
        }
        for (Map.Entry entry : providerConfig.getProperties().entrySet()) {
            descriptor = provider.getPropertyDescriptor((String)entry.getKey());
            references = parser.parseTokens((String)entry.getValue());
            variableImpact = Query.prepare((String)((String)entry.getValue())).getVariableImpact();
            configuration = new PropertyConfiguration((String)entry.getValue(), references, references.toReferenceList(), variableImpact);
            propertyStringMap.put(descriptor, configuration);
            StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)resourceReferenceFactory, descriptor);
            propertyMap.put(descriptor, (PropertyValue)new StandardPropertyValue((ResourceContext)resourceContext, (String)entry.getValue(), null, parameterLookup));
        }
        SimpleProcessLogger logger = new SimpleProcessLogger(providerConfig.getId(), provider, (LoggingContext)new StandardLoggingContext(null));
        StandardStateProviderInitializationContext standardStateProviderInitializationContext = new StandardStateProviderInitializationContext(providerConfig.getId(), propertyMap, sslContext, logger);
        descriptor = provider;
        synchronized (descriptor) {
            provider.initialize((StateProviderInitializationContext)standardStateProviderInitializationContext);
        }
        StandardValidationContext validationContext = new StandardValidationContext(null, propertyStringMap, null, null, null, null, true);
        Collection results = provider.validate((ValidationContext)validationContext);
        StringBuilder validationFailures = new StringBuilder();
        int invalidCount = 0;
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            validationFailures.append(result).append("\n");
            ++invalidCount;
        }
        if (invalidCount > 0) {
            throw new IllegalStateException("Could not initialize State Providers because the " + String.valueOf(providerConfig.getScope()) + " Provider is not valid. The following " + invalidCount + " Validation Errors occurred:\n" + String.valueOf(validationFailures) + "\nPlease check the configuration of the " + String.valueOf(providerConfig.getScope()) + " Provider with ID [" + providerConfig.getId() + "]");
        }
        return provider;
    }

    private static void performMethodInjection(Object instance, Class<?> stateProviderClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : stateProviderClass.getMethods()) {
            Class<?> argumentType;
            if (!method.isAnnotationPresent(StateProviderContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
            method.invoke(instance, nifiProperties);
        }
        Class<?> parentClass = stateProviderClass.getSuperclass();
        if (parentClass != null && StateProvider.class.isAssignableFrom(parentClass)) {
            StandardStateManagerProvider.performMethodInjection(instance, parentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider instantiateStateProvider(ExtensionManager extensionManager, String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List bundles = extensionManager.getBundles(type);
            if (bundles.size() == 0) {
                throw new IllegalStateException(String.format("The specified class '%s' is not known to this nifi.", type));
            }
            if (bundles.size() > 1) {
                throw new IllegalStateException(String.format("Multiple bundles found for the specified class '%s', only one is allowed.", type));
            }
            Bundle bundle = (Bundle)bundles.get(0);
            ClassLoader detectedClassLoaderForType = bundle.getClassLoader();
            Class<?> rawClass = Class.forName(type, true, detectedClassLoaderForType);
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<StateProvider> mgrClass = rawClass.asSubclass(StateProvider.class);
            StateProvider provider = mgrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                StandardStateManagerProvider.performMethodInjection(provider, mgrClass);
            }
            catch (InvocationTargetException e) {
                logger.error("Failed to inject nifi.properties to the '{}' state provider.", (Object)type, (Object)e);
            }
            StateProvider stateProvider = StandardStateManagerProvider.withNarClassLoader(provider);
            return stateProvider;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private static StateProvider withNarClassLoader(final StateProvider stateProvider) {
        return new StateProvider(){

            public void initialize(StateProviderInitializationContext context) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.initialize(context);
                }
            }

            public void shutdown() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.shutdown();
                }
            }

            public void setState(Map<String, String> state, String componentId) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.setState(state, componentId);
                }
            }

            public StateMap getState(String componentId) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    StateMap stateMap = stateProvider.getState(componentId);
                    return stateMap;
                }
            }

            public boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    boolean bl = stateProvider.replace(oldValue, newValue, componentId);
                    return bl;
                }
            }

            public void clear(String componentId) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.clear(componentId);
                }
            }

            public void onComponentRemoved(String componentId) throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.onComponentRemoved(componentId);
                }
            }

            public void enable() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.enable();
                }
            }

            public void disable() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.disable();
                }
            }

            public boolean isEnabled() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    boolean bl = stateProvider.isEnabled();
                    return bl;
                }
            }

            public Scope[] getSupportedScopes() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    Scope[] scopeArray = stateProvider.getSupportedScopes();
                    return scopeArray;
                }
            }

            public Collection<ValidationResult> validate(ValidationContext context) {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    Collection collection = stateProvider.validate(context);
                    return collection;
                }
            }

            public PropertyDescriptor getPropertyDescriptor(String name) {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    PropertyDescriptor propertyDescriptor = stateProvider.getPropertyDescriptor(name);
                    return propertyDescriptor;
                }
            }

            public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    stateProvider.onPropertyModified(descriptor, oldValue, newValue);
                }
            }

            public List<PropertyDescriptor> getPropertyDescriptors() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    List list = stateProvider.getPropertyDescriptors();
                    return list;
                }
            }

            public String getIdentifier() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    String string = stateProvider.getIdentifier();
                    return string;
                }
            }

            public boolean isComponentEnumerationSupported() {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    boolean bl = stateProvider.isComponentEnumerationSupported();
                    return bl;
                }
            }

            public Collection<String> getStoredComponentIds() throws IOException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    Collection collection = stateProvider.getStoredComponentIds();
                    return collection;
                }
            }
        };
    }

    public synchronized StateManager getStateManager(String componentId) {
        StateManager stateManager = (StateManager)this.stateManagers.get(componentId);
        if (stateManager != null) {
            return stateManager;
        }
        stateManager = new StandardStateManager(this.localStateProvider, this.clusterStateProvider, componentId);
        this.stateManagers.put(componentId, stateManager);
        return stateManager;
    }

    public synchronized void shutdown() {
        this.localStateProvider.shutdown();
        if (this.clusterStateProvider != null) {
            this.clusterStateProvider.shutdown();
        }
        if (this.previousClusterStateProvider != null) {
            this.previousClusterStateProvider.shutdown();
        }
    }

    public void enableClusterProvider() {
        this.clusterStateProvider.enable();
        if (this.previousClusterStateProvider != null) {
            this.previousClusterStateProvider.enable();
            StandardStateManagerProvider.loadPreviousClusterState(this.previousClusterStateProvider, this.clusterStateProvider);
        }
    }

    public void disableClusterProvider() {
        this.clusterStateProvider.disable();
    }

    public void onComponentRemoved(String componentId) {
        StateManager mgr = (StateManager)this.stateManagers.remove(componentId);
        if (mgr == null) {
            return;
        }
        try {
            mgr.clear(Scope.CLUSTER);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear clustered state for the component", (Object)componentId, (Object)e);
        }
        try {
            mgr.clear(Scope.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear local state for the component", (Object)componentId, (Object)e);
        }
        try {
            this.localStateProvider.onComponentRemoved(componentId);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its local state", (Object)componentId, (Object)e);
        }
        if (this.clusterStateProvider != null) {
            try {
                this.clusterStateProvider.onComponentRemoved(componentId);
            }
            catch (Exception e) {
                logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its clustered state", (Object)componentId, (Object)e);
            }
        }
    }
}

