/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.PropertyConfigurationMapper;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.util.FormatUtils;

public class StandardConfigurationContext
implements ConfigurationContext {
    private final ComponentNode component;
    private final ControllerServiceLookup serviceLookup;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final String schedulingPeriod;
    private final Long schedulingNanos;
    private final Map<PropertyDescriptor, String> properties;
    private final String annotationData;

    public StandardConfigurationContext(ComponentNode component, ControllerServiceLookup serviceLookup, String schedulingPeriod) {
        this(component, serviceLookup, schedulingPeriod, component.getEffectivePropertyValues(), component.getAnnotationData());
    }

    public StandardConfigurationContext(ComponentNode component, Map<String, String> propertyOverrides, String annotationDataOverride, ParameterLookup parameterLookup, ControllerServiceLookup serviceLookup, String schedulingPeriod) {
        this(component, serviceLookup, schedulingPeriod, StandardConfigurationContext.resolvePropertyValues(component, parameterLookup, propertyOverrides), annotationDataOverride);
    }

    public StandardConfigurationContext(ComponentNode component, ControllerServiceLookup serviceLookup, String schedulingPeriod, Map<PropertyDescriptor, String> propertyValues, String annotationData) {
        this.component = component;
        this.serviceLookup = serviceLookup;
        this.schedulingPeriod = schedulingPeriod;
        this.properties = Collections.unmodifiableMap(propertyValues);
        this.annotationData = annotationData;
        this.schedulingNanos = schedulingPeriod == null ? null : (FormatUtils.TIME_DURATION_PATTERN.matcher(schedulingPeriod).matches() ? Long.valueOf(FormatUtils.getTimeDuration((String)schedulingPeriod, (TimeUnit)TimeUnit.NANOSECONDS)) : null);
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : propertyValues.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepareWithParametersPreEvaluated((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    private static Map<PropertyDescriptor, String> resolvePropertyValues(ComponentNode component, ParameterLookup parameterLookup, Map<String, String> propertyOverrides) {
        LinkedHashMap<PropertyDescriptor, String> resolvedProperties = new LinkedHashMap<PropertyDescriptor, String>(component.getEffectivePropertyValues());
        PropertyConfigurationMapper configurationMapper = new PropertyConfigurationMapper();
        for (Map.Entry<String, String> entry : propertyOverrides.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            PropertyDescriptor propertyDescriptor = component.getPropertyDescriptor(propertyName);
            if (propertyValue == null) {
                resolvedProperties.remove(propertyDescriptor);
                continue;
            }
            PropertyConfiguration configuration = configurationMapper.mapRawPropertyValuesToPropertyConfiguration(propertyDescriptor, propertyValue);
            String effectiveValue = configuration.getEffectiveValue(parameterLookup);
            resolvedProperties.put(propertyDescriptor, effectiveValue);
        }
        return resolvedProperties;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String resolvedValue;
        String configuredValue = this.properties.get(property);
        if (configuredValue == null) {
            PropertyDescriptor resolvedDescriptor = this.component.getPropertyDescriptor(property.getName());
            resolvedValue = resolvedDescriptor.getDefaultValue();
        } else {
            resolvedValue = configuredValue;
        }
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), property);
        return new StandardPropertyValue((ResourceContext)resourceContext, resolvedValue, this.serviceLookup, this.component.getParameterLookup(), this.preparedQueries.get(property));
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.properties;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return this.schedulingNanos == null ? null : Long.valueOf(timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS));
    }

    public String getName() {
        return this.component.getName();
    }
}

