/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public class ConnectionUtils {
    public static FlowFileCloneResult clone(FlowFileRecord flowFile, Collection<Connection> destinations, FlowFileRepository flowFileRepository, ContentRepository contentRepository) {
        HashMap<FlowFileQueue, List<FlowFileRecord>> flowFilesToEnqueue = new HashMap<FlowFileQueue, List<FlowFileRecord>>();
        if (destinations.size() == 1) {
            Connection firstConnection = destinations.iterator().next();
            flowFilesToEnqueue.put(firstConnection.getFlowFileQueue(), Collections.singletonList(flowFile));
            RepositoryRecord repoRecord = ConnectionUtils.createRepositoryRecord(flowFile, firstConnection.getFlowFileQueue());
            return new FlowFileCloneResult(flowFilesToEnqueue, Collections.singletonList(repoRecord));
        }
        ArrayList<RepositoryRecord> repositoryRecords = new ArrayList<RepositoryRecord>();
        Iterator<Connection> itr = destinations.iterator();
        Connection firstConnection = itr.next();
        while (itr.hasNext()) {
            Connection destination = itr.next();
            StandardFlowFileRecord.Builder builder = new StandardFlowFileRecord.Builder().fromFlowFile(flowFile);
            long id = flowFileRepository.getNextFlowFileSequence();
            builder.id(id);
            String newUuid = UUID.randomUUID().toString();
            builder.addAttribute(CoreAttributes.UUID.key(), newUuid);
            FlowFileRecord clone = builder.build();
            ContentClaim claim = clone.getContentClaim();
            if (claim != null && contentRepository != null) {
                contentRepository.incrementClaimaintCount(claim);
            }
            RepositoryRecord repoRecord = ConnectionUtils.createRepositoryRecord(clone, destination.getFlowFileQueue());
            repositoryRecords.add(repoRecord);
            List flowFiles = flowFilesToEnqueue.computeIfAbsent(destination.getFlowFileQueue(), k -> new ArrayList());
            flowFiles.add(clone);
        }
        flowFilesToEnqueue.put(firstConnection.getFlowFileQueue(), Collections.singletonList(flowFile));
        repositoryRecords.add(ConnectionUtils.createRepositoryRecord(flowFile, firstConnection.getFlowFileQueue()));
        return new FlowFileCloneResult(flowFilesToEnqueue, repositoryRecords);
    }

    private static RepositoryRecord createRepositoryRecord(FlowFileRecord flowFile, FlowFileQueue destinationQueue) {
        StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(null, flowFile);
        repoRecord.setWorking(flowFile, Collections.emptyMap(), false);
        repoRecord.setDestination(destinationQueue);
        return repoRecord;
    }

    public static class FlowFileCloneResult {
        private final Map<FlowFileQueue, List<FlowFileRecord>> flowFilesToEnqueue;
        private final List<RepositoryRecord> repositoryRecords;

        private FlowFileCloneResult(Map<FlowFileQueue, List<FlowFileRecord>> flowFilesToEnqueue, List<RepositoryRecord> repositoryRecords) {
            this.flowFilesToEnqueue = flowFilesToEnqueue;
            this.repositoryRecords = repositoryRecords;
        }

        public List<RepositoryRecord> getRepositoryRecords() {
            return this.repositoryRecords;
        }

        public int distributeFlowFiles() {
            if (this.flowFilesToEnqueue.isEmpty()) {
                return 0;
            }
            int enqueued = 0;
            for (Map.Entry<FlowFileQueue, List<FlowFileRecord>> entry : this.flowFilesToEnqueue.entrySet()) {
                FlowFileQueue queue = entry.getKey();
                List<FlowFileRecord> flowFiles = entry.getValue();
                if (flowFiles.isEmpty()) continue;
                queue.putAll(flowFiles);
                enqueued += flowFiles.size();
            }
            return enqueued;
        }

        public Map<FlowFileQueue, List<FlowFileRecord>> getFlowFilesToEnqueue() {
            return this.flowFilesToEnqueue;
        }
    }
}

