/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.asset;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.asset.Asset;

public class StandardAsset
implements Asset {
    private final String identifier;
    private final String parameterContextIdentifier;
    private final String name;
    private final File file;
    private final String digest;

    public StandardAsset(String identifier, String paramContextIdentifier, String name, File file, String digest) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier is required");
        this.parameterContextIdentifier = Objects.requireNonNull(paramContextIdentifier, "Parameter Context Identifier is required");
        this.name = Objects.requireNonNull(name, "Name is required");
        this.file = Objects.requireNonNull(file, "File is required");
        this.digest = digest;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getParameterContextIdentifier() {
        return this.parameterContextIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public Optional<String> getDigest() {
        return Optional.ofNullable(this.digest);
    }
}

