/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

class EventLoopGroupFactory {
    private static final String DEFAULT_THREAD_NAME_PREFIX = "NettyEventLoopGroup";
    private static final boolean DAEMON_THREAD_ENABLED = true;
    private String threadNamePrefix = "NettyEventLoopGroup";
    private int workerThreads;

    EventLoopGroupFactory() {
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = Objects.requireNonNull(threadNamePrefix, "Thread Name Prefix required");
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    protected EventLoopGroup getEventLoopGroup() {
        return new NioEventLoopGroup(this.workerThreads, this.getThreadFactory());
    }

    private ThreadFactory getThreadFactory() {
        return new DefaultThreadFactory(this.threadNamePrefix, true);
    }
}

