/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.message.ByteArrayMessage;
import org.apache.nifi.event.transport.netty.FilteringStrategy;
import org.apache.nifi.event.transport.netty.NettyEventServerFactory;
import org.apache.nifi.event.transport.netty.channel.ByteArrayMessageChannelHandler;
import org.apache.nifi.event.transport.netty.channel.FilteringByteArrayMessageChannelHandler;
import org.apache.nifi.event.transport.netty.channel.LogExceptionChannelHandler;
import org.apache.nifi.event.transport.netty.codec.DatagramByteArrayMessageDecoder;
import org.apache.nifi.event.transport.netty.codec.SocketByteArrayMessageDecoder;
import org.apache.nifi.logging.ComponentLog;

public class ByteArrayMessageNettyEventServerFactory
extends NettyEventServerFactory {
    private static final boolean STRIP_DELIMITER = true;

    public ByteArrayMessageNettyEventServerFactory(ComponentLog log, InetAddress address, int port, TransportProtocol protocol, byte[] delimiter, int maxFrameLength, BlockingQueue<ByteArrayMessage> messages) {
        this(log, address, port, protocol, delimiter, maxFrameLength, messages, FilteringStrategy.DISABLED);
    }

    public ByteArrayMessageNettyEventServerFactory(ComponentLog log, InetAddress address, int port, TransportProtocol protocol, byte[] delimiter, int maxFrameLength, BlockingQueue<ByteArrayMessage> messages, FilteringStrategy filteringStrategy) {
        super(address, port, protocol);
        LogExceptionChannelHandler logExceptionChannelHandler = new LogExceptionChannelHandler(log);
        ByteArrayMessageChannelHandler byteArrayMessageChannelHandler = FilteringStrategy.EMPTY == filteringStrategy ? new FilteringByteArrayMessageChannelHandler(messages) : new ByteArrayMessageChannelHandler(messages);
        if (TransportProtocol.UDP.equals((Object)protocol)) {
            this.setHandlerSupplier(() -> Arrays.asList(new ChannelHandler[]{new DatagramByteArrayMessageDecoder(), byteArrayMessageChannelHandler, logExceptionChannelHandler}));
        } else {
            this.setHandlerSupplier(() -> Arrays.asList(new ChannelHandler[]{new DelimiterBasedFrameDecoder(maxFrameLength, true, Unpooled.wrappedBuffer((byte[])delimiter)), new ByteArrayDecoder(), new SocketByteArrayMessageDecoder(), byteArrayMessageChannelHandler, logExceptionChannelHandler}));
        }
    }
}

