/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty;

import io.netty.handler.codec.string.LineEncoder;
import io.netty.handler.codec.string.LineSeparator;
import io.netty.handler.codec.string.StringEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.nifi.event.transport.configuration.LineEnding;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.NettyEventSenderFactory;
import org.apache.nifi.event.transport.netty.channel.LogExceptionChannelHandler;
import org.apache.nifi.logging.ComponentLog;

public class StringNettyEventSenderFactory
extends NettyEventSenderFactory<String> {
    public StringNettyEventSenderFactory(ComponentLog log, String address, int port, TransportProtocol protocol, Charset charset, LineEnding lineEnding) {
        super(address, port, protocol);
        ArrayList<LogExceptionChannelHandler> handlers = new ArrayList<LogExceptionChannelHandler>();
        handlers.add(new LogExceptionChannelHandler(log));
        handlers.add((LogExceptionChannelHandler)new StringEncoder(charset));
        if (LineEnding.UNIX.equals((Object)lineEnding)) {
            handlers.add((LogExceptionChannelHandler)new LineEncoder(LineSeparator.UNIX, charset));
        }
        this.setHandlerSupplier(() -> handlers);
    }
}

