/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.event.transport.EventServer;
import org.apache.nifi.event.transport.configuration.ShutdownQuietPeriod;
import org.apache.nifi.event.transport.configuration.ShutdownTimeout;

class NettyEventServer
implements EventServer {
    private final EventLoopGroup group;
    private final Channel channel;
    private final Duration shutdownQuietPeriod;
    private final Duration shutdownTimeout;

    NettyEventServer(EventLoopGroup group, Channel channel) {
        this(group, channel, ShutdownQuietPeriod.DEFAULT.getDuration(), ShutdownTimeout.DEFAULT.getDuration());
    }

    NettyEventServer(EventLoopGroup group, Channel channel, Duration quietPeriod, Duration timeout) {
        this.group = group;
        this.channel = channel;
        this.shutdownQuietPeriod = quietPeriod;
        this.shutdownTimeout = timeout;
    }

    @Override
    public void shutdown() {
        try {
            if (this.channel.isOpen()) {
                this.channel.close().syncUninterruptibly();
            }
        }
        finally {
            this.group.shutdownGracefully(this.shutdownQuietPeriod.toMillis(), this.shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS).syncUninterruptibly();
        }
    }
}

