/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class StandardChannelInitializer<T extends Channel>
extends ChannelInitializer<T> {
    private final Supplier<List<ChannelHandler>> handlerSupplier;
    private Duration writeTimeout = Duration.ofSeconds(30L);

    public StandardChannelInitializer(Supplier<List<ChannelHandler>> handlerSupplier) {
        this.handlerSupplier = Objects.requireNonNull(handlerSupplier);
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = Objects.requireNonNull(writeTimeout);
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS)});
        this.handlerSupplier.get().forEach(xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
    }
}

