/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.nifi.util.TestRunner;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractElasticsearchITBase {
    protected static final DockerImageName IMAGE = DockerImageName.parse((String)System.getProperty("elasticsearch.docker.image", "docker.elastic.co/elasticsearch/elasticsearch:9.0.2"));
    protected static final String ELASTIC_USER_PASSWORD = System.getProperty("elasticsearch.elastic_user.password", RandomStringUtils.randomAlphanumeric((int)10, (int)20));
    private static final int PORT = 9200;
    protected static final ElasticsearchContainer ELASTICSEARCH_CONTAINER = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(IMAGE).withPassword(ELASTIC_USER_PASSWORD).withEnv("xpack.security.enabled", "true")).withEnv("xpack.license.self_generated.type", "trial")).withEnv("xpack.security.authc.api_key.enabled", "true")).withEnv("network.bind_host", "_local_,_site_")).withEnv("network.publish_host", "127.0.0.1")).withEnv("http.port", String.valueOf(9200))).withExposedPorts(new Integer[]{9200})).withCreateContainerCmdModifier(cmd -> cmd.withHostConfig(new HostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)9200), new ExposedPort(9200))})));
    protected static final String CLIENT_SERVICE_NAME = "Client Service";
    protected static final String INDEX = "messages";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final boolean ENABLE_TEST_CONTAINERS = "true".equalsIgnoreCase(System.getProperty("elasticsearch.testcontainers.enabled"));
    protected static String elasticsearchHost;
    protected TestRunner runner;
    protected static String type;
    static RestClient testDataManagementClient;

    protected static void startTestContainer() {
        if (ENABLE_TEST_CONTAINERS) {
            ELASTICSEARCH_CONTAINER.start();
            elasticsearchHost = String.format("http://%s", ELASTICSEARCH_CONTAINER.getHttpHostAddress());
        } else {
            elasticsearchHost = System.getProperty("elasticsearch.endpoint", "http://localhost:9200");
        }
    }

    protected static void stopTestContainer() {
        if (ENABLE_TEST_CONTAINERS) {
            ELASTICSEARCH_CONTAINER.stop();
        }
    }

    @BeforeAll
    static void beforeAll() throws IOException {
        AbstractElasticsearchITBase.startTestContainer();
        if (type == null) {
            type = "";
        }
        System.out.printf("%n%n%n%n%n%n%n%n%n%n%n%n%n%n%nTYPE: %s%nIMAGE: %s:%s%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n", type, IMAGE.getRepository(), IMAGE.getVersionPart());
        AbstractElasticsearchITBase.setupTestData();
    }

    private static String[] getElasticVersion() {
        String fullVersion = IMAGE.getVersionPart();
        String[] parts = fullVersion.split("\\.");
        if (parts.length == 1) {
            throw new IllegalArgumentException("The elasticsearch version should have at least a major and minor version ex. 7.17");
        }
        return parts;
    }

    protected static int getElasticMajorVersion() {
        return Integer.parseInt(AbstractElasticsearchITBase.getElasticVersion()[0]);
    }

    protected static int getElasticMinorVersion() {
        return Integer.parseInt(AbstractElasticsearchITBase.getElasticVersion()[1]);
    }

    protected static void setupTestData() throws IOException {
        int majorVersion = AbstractElasticsearchITBase.getElasticMajorVersion();
        URL url = URI.create(elasticsearchHost).toURL();
        testDataManagementClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(url.getHost(), url.getPort(), url.getProtocol())}).setHttpClientConfigCallback(httpClientBuilder -> {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("elastic", ELASTIC_USER_PASSWORD);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            return httpClientBuilder;
        }).build();
        String script = String.format("src/test/resources/setup-%s.script", majorVersion);
        List<SetupAction> actions = AbstractElasticsearchITBase.readSetupActions(script);
        for (SetupAction action : actions) {
            String endpoint = String.format("%s/%s", elasticsearchHost, action.path);
            Request request = new Request(action.verb, endpoint);
            NStringEntity jsonBody = new NStringEntity(action.json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)jsonBody);
            try {
                testDataManagementClient.performRequest(request);
            }
            catch (ResponseException re) {
                throw new IllegalStateException("Error performing action " + String.valueOf(action), re);
            }
        }
    }

    protected static void tearDownTestData(List<String> testIndices) {
        testIndices.forEach(AbstractElasticsearchITBase::deleteIndex);
    }

    protected static void deleteIndex(String index) {
        Request request = new Request("DELETE", String.format("%s/%s", elasticsearchHost, index));
        try {
            testDataManagementClient.performRequest(request);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error deleting index " + index, ioe);
        }
    }

    protected String prettyJson(Object o) throws JsonProcessingException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
    }

    private static List<SetupAction> readSetupActions(String scriptPath) throws IOException {
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(scriptPath, new String[0]), new OpenOption[0])));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.isBlank() && !line.trim().startsWith("#")) {
                    String verb = line.substring(0, line.indexOf(":"));
                    String path = line.substring(verb.length() + 1, line.indexOf(":", verb.length() + 1));
                    int loc = verb.length() + path.length() + 2;
                    String json = line.substring(loc);
                    actions.add(new SetupAction(verb, path, json));
                }
                line = reader.readLine();
            }
        }
        return actions;
    }

    private record SetupAction(String verb, String path, String json) {
        @Override
        public String toString() {
            return "SetupAction{verb='" + this.verb + "', path='" + this.path + "'}";
        }
    }
}

