/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractPutElasticsearch;
import org.apache.nifi.util.StringUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"json", "elasticsearch", "elasticsearch5", "elasticsearch6", "elasticsearch7", "elasticsearch8", "put", "index"})
@CapabilityDescription(value="An Elasticsearch put processor that uses the official Elastic REST client libraries.")
@WritesAttributes(value={@WritesAttribute(attribute="elasticsearch.put.error", description="The error message provided by Elasticsearch if there is an error indexing the document.")})
@DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the _bulk request body. If FlowFiles are batched, only the first FlowFile in the batch is used to evaluate property values.")
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="The Batch of FlowFiles will be stored in memory until the bulk operation is performed.")
public class PutElasticsearchJson
extends AbstractPutElasticsearch {
    static final Relationship REL_FAILED_DOCUMENTS = new Relationship.Builder().name("errors").description("If a \"Output Error Documents\" is set, any FlowFile(s) corresponding to Elasticsearch document(s) that resulted in an \"error\" (within Elasticsearch) will be routed here.").autoTerminateDefault(true).build();
    static final PropertyDescriptor ID_ATTRIBUTE = new PropertyDescriptor.Builder().name("put-es-json-id-attr").displayName("Identifier Attribute").description("The name of the FlowFile attribute containing the identifier for the document. If the Index Operation is \"index\", this property may be left empty or evaluate to an empty value, in which case the document's identifier will be auto-generated by Elasticsearch. For all other Index Operations, the attribute must evaluate to a non-empty value.").required(false).expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.ATTRIBUTE_KEY_VALIDATOR).build();
    static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("put-es-json-charset").displayName("Character Set").description("Specifies the character set of the document data.").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(StandardCharsets.UTF_8.name()).required(true).build();
    static final PropertyDescriptor OUTPUT_ERROR_DOCUMENTS = new PropertyDescriptor.Builder().name("put-es-json-error-documents").displayName("Output Error Documents").description("If this configuration property is true, the response from Elasticsearch will be examined for failed documents and the FlowFile(s) associated with the failed document(s) will be sent to the \"" + REL_FAILED_DOCUMENTS.getName() + "\" relationship.").allowableValues(new String[]{"true", "false"}).defaultValue("false").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();
    static final PropertyDescriptor NOT_FOUND_IS_SUCCESSFUL = new PropertyDescriptor.Builder().name("put-es-json-not_found-is-error").displayName("Treat \"Not Found\" as Error").description("If true, \"not_found\" Elasticsearch Document associated FlowFiles will be routed to the \"" + REL_SUCCESS.getName() + "\" relationship, otherwise to the \"" + REL_FAILED_DOCUMENTS.getName() + "\" relationship.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").required(false).dependsOn(OUTPUT_ERROR_DOCUMENTS, "true", new String[0]).build();
    static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(ID_ATTRIBUTE, INDEX_OP, INDEX, TYPE, BATCH_SIZE, CHARSET, CLIENT_SERVICE, LOG_ERROR_RESPONSES, OUTPUT_ERROR_DOCUMENTS, NOT_FOUND_IS_SUCCESSFUL));
    static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE, REL_RETRY, REL_FAILED_DOCUMENTS)));
    private boolean outputErrors;
    private final ObjectMapper inputMapper = new ObjectMapper();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
        this.outputErrors = context.getProperty(OUTPUT_ERROR_DOCUMENTS).asBoolean();
        this.notFoundIsSuccessful = context.getProperty(NOT_FOUND_IS_SUCCESSFUL).asBoolean();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        int batchSize = context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger();
        List flowFiles = session.get(batchSize);
        if (flowFiles.isEmpty()) {
            return;
        }
        String idAttribute = context.getProperty(ID_ATTRIBUTE).getValue();
        ArrayList<FlowFile> originals = new ArrayList<FlowFile>(flowFiles.size());
        ArrayList<IndexOperationRequest> operations = new ArrayList<IndexOperationRequest>(flowFiles.size());
        for (FlowFile input : flowFiles) {
            String indexOp = context.getProperty(INDEX_OP).evaluateAttributeExpressions(input).getValue();
            String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
            String type = context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue();
            String id = StringUtils.isNotBlank((String)idAttribute) && StringUtils.isNotBlank((String)input.getAttribute(idAttribute)) ? input.getAttribute(idAttribute) : null;
            String charset = context.getProperty(CHARSET).evaluateAttributeExpressions(input).getValue();
            try {
                InputStream inStream = session.read(input);
                Throwable throwable = null;
                try {
                    byte[] result = IOUtils.toByteArray((InputStream)inStream);
                    Map contentMap = (Map)this.inputMapper.readValue(new String(result, charset), Map.class);
                    IndexOperationRequest.Operation o = IndexOperationRequest.Operation.forValue((String)indexOp);
                    operations.add(new IndexOperationRequest(index, type, id, contentMap, o));
                    originals.add(input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inStream == null) continue;
                    if (throwable != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inStream.close();
                }
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not read FlowFile content valid JSON.", (Throwable)ioe);
                input = session.putAttribute(input, "elasticsearch.put.error", ioe.getMessage());
                session.penalize(input);
                session.transfer(input, REL_FAILURE);
            }
            catch (Exception ex) {
                this.getLogger().error("Could not index documents.", (Throwable)ex);
                input = session.putAttribute(input, "elasticsearch.put.error", ex.getMessage());
                session.penalize(input);
                session.transfer(input, REL_FAILURE);
            }
        }
        if (!originals.isEmpty()) {
            try {
                List<FlowFile> errorDocuments = this.indexDocuments(operations, originals, context);
                session.transfer(errorDocuments, REL_FAILED_DOCUMENTS);
                errorDocuments.forEach(e -> session.getProvenanceReporter().send(e, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(context.getProperty(INDEX).evaluateAttributeExpressions(e).getValue(), context.getProperty(TYPE).evaluateAttributeExpressions(e).getValue()), "Elasticsearch _bulk operation error"));
                List<FlowFile> successfulDocuments = originals.stream().filter(f -> !errorDocuments.contains(f)).collect(Collectors.toList());
                session.transfer(successfulDocuments, REL_SUCCESS);
                successfulDocuments.forEach(s -> session.getProvenanceReporter().send(s, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(context.getProperty(INDEX).evaluateAttributeExpressions(s).getValue(), context.getProperty(TYPE).evaluateAttributeExpressions(s).getValue())));
            }
            catch (ElasticsearchException ese) {
                String msg = String.format("Encountered a server-side problem with Elasticsearch. %s", ese.isElastic() ? "Routing to retry." : "Routing to failure");
                this.getLogger().error(msg, (Throwable)ese);
                Relationship rel = ese.isElastic() ? REL_RETRY : REL_FAILURE;
                this.transferFlowFilesOnException((Exception)((Object)ese), rel, session, true, originals.toArray(new FlowFile[0]));
            }
            catch (JsonProcessingException jpe) {
                this.getLogger().warn("Could not log Elasticsearch operation errors nor determine which documents errored.", (Throwable)jpe);
                Relationship rel = this.outputErrors ? REL_FAILED_DOCUMENTS : REL_FAILURE;
                this.transferFlowFilesOnException((Exception)((Object)jpe), rel, session, true, originals.toArray(new FlowFile[0]));
            }
            catch (Exception ex) {
                this.getLogger().error("Could not index documents.", (Throwable)ex);
                this.transferFlowFilesOnException(ex, REL_FAILURE, session, false, originals.toArray(new FlowFile[0]));
                context.yield();
            }
        } else {
            this.getLogger().warn("No FlowFiles successfully parsed for sending to Elasticsearch");
        }
    }

    private List<FlowFile> indexDocuments(List<IndexOperationRequest> operations, List<FlowFile> originals, ProcessContext context) throws JsonProcessingException {
        IndexOperationResponse response = ((ElasticSearchClientService)this.clientService.get()).bulk(operations, this.getUrlQueryParameters(context, originals.get(0)));
        ArrayList<FlowFile> errorDocuments = new ArrayList<FlowFile>(response.getItems() == null ? 0 : response.getItems().size());
        ArrayList<Predicate<Map<String, Object>>> errorItemFilters = new ArrayList<Predicate<Map<String, Object>>>(2);
        if (response.hasErrors()) {
            this.logElasticsearchDocumentErrors(response);
            if (this.outputErrors) {
                errorItemFilters.add(this.isElasticsearchError());
            }
        }
        if (!this.notFoundIsSuccessful) {
            errorItemFilters.add(this.isElasticsearchNotFound());
        }
        if (!errorItemFilters.isEmpty()) {
            this.findElasticsearchResponseIndices(response, errorItemFilters.toArray(new Predicate[0])).forEach(index -> errorDocuments.add((FlowFile)originals.get((Integer)index)));
        }
        return errorDocuments;
    }
}

