/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.OperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processors.elasticsearch.AbstractByQueryElasticsearch;

@WritesAttributes(value={@WritesAttribute(attribute="elasticsearch.update.took", description="The amount of time that it took to complete the update operation in ms."), @WritesAttribute(attribute="elasticsearch.update.error", description="The error message provided by Elasticsearch if there is an error running the update.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"elastic", "elasticsearch", "elasticsearch5", "elasticsearch6", "elasticsearch7", "update", "query"})
@CapabilityDescription(value="Update documents in an Elasticsearch index using a query. The query can be loaded from a flowfile body or from the Query parameter.")
@DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the query request body")
public class UpdateByQueryElasticsearch
extends AbstractByQueryElasticsearch {
    static final String TOOK_ATTRIBUTE = "elasticsearch.update.took";
    static final String ERROR_ATTRIBUTE = "elasticsearch.update.error";

    @Override
    String getTookAttribute() {
        return TOOK_ATTRIBUTE;
    }

    @Override
    String getErrorAttribute() {
        return ERROR_ATTRIBUTE;
    }

    @Override
    OperationResponse performOperation(ElasticSearchClientService clientService, String query, String index, String type, Map<String, String> requestParameters) {
        return clientService.updateByQuery(query, index, type, requestParameters);
    }
}

