/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;

public interface ElasticsearchRestProcessor {
    public static final String ATTR_RECORD_COUNT = "record.count";
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-rest-fetch-index").displayName("Index").description("The name of the index to use.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-rest-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching).").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("el-rest-query").displayName("Query").description("A query in JSON syntax, not Lucene syntax. Ex: {\"query\":{\"match\":{\"somefield\":\"somevalue\"}}}. If this parameter is not set, the query will be read from the flowfile content.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor QUERY_ATTRIBUTE = new PropertyDescriptor.Builder().name("el-query-attribute").displayName("Query Attribute").description("If set, the executed query will be set on each result flowfile in the specified attribute.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(Validator.VALID).required(false).build();
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An Elasticsearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();
    public static final PropertyDescriptor LOG_ERROR_RESPONSES = new PropertyDescriptor.Builder().name("put-es-record-log-error-responses").displayName("Log Error Responses").description("If this is enabled, errors will be logged to the NiFi logs at the error log level. Otherwise, they will only be logged if debug logging is enabled on NiFi as a whole. The purpose of this option is to give the user the ability to debug failed operations without having to turn on debug logging.").allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All flowfiles that fail for reasons unrelated to server availability go to this relationship.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("All flowfiles that fail due to server/cluster availability go to this relationship.").build();

    default public String getQuery(FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        String retVal = null;
        if (context.getProperty(QUERY).isSet()) {
            retVal = context.getProperty(QUERY).evaluateAttributeExpressions(input).getValue();
        } else if (input != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            session.exportTo(input, (OutputStream)out);
            out.close();
            retVal = out.toString();
        }
        return retVal;
    }

    default public Map<String, String> getUrlQueryParameters(ProcessContext context, FlowFile flowFile) {
        return context.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic() && e.getValue() != null).collect(Collectors.toMap(e -> ((PropertyDescriptor)e.getKey()).getName(), e -> context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions(flowFile).getValue()));
    }
}

