/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.distributed.cache.server.CacheRecord;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapCacheRecord;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMapCache
implements MapCache {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMapCache.class);
    private final Map<ByteBuffer, MapCacheRecord> cache = new HashMap<ByteBuffer, MapCacheRecord>();
    private final SortedMap<MapCacheRecord, ByteBuffer> inverseCacheMap;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final String serviceIdentifier;
    private final int maxSize;

    public SimpleMapCache(String serviceIdentifier, int maxSize, EvictionPolicy evictionPolicy) {
        this.inverseCacheMap = new ConcurrentSkipListMap<CacheRecord, ByteBuffer>(evictionPolicy.getComparator());
        this.serviceIdentifier = serviceIdentifier;
        this.maxSize = maxSize;
    }

    public String toString() {
        return "SimpleSetCache[service id=" + this.serviceIdentifier + "]";
    }

    private MapCacheRecord evict() {
        if (this.cache.size() < this.maxSize) {
            return null;
        }
        MapCacheRecord recordToEvict = this.inverseCacheMap.firstKey();
        ByteBuffer valueToEvict = (ByteBuffer)this.inverseCacheMap.remove(recordToEvict);
        this.cache.remove(valueToEvict);
        if (logger.isDebugEnabled()) {
            logger.debug("Evicting value {} from cache", (Object)new String(valueToEvict.array(), StandardCharsets.UTF_8));
        }
        return recordToEvict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapPutResult putIfAbsent(ByteBuffer key, ByteBuffer value) {
        this.writeLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                MapCacheRecord evicted = this.evict();
                MapCacheRecord newRecord = new MapCacheRecord(key, value);
                this.cache.put(key, newRecord);
                this.inverseCacheMap.put(newRecord, key);
                if (evicted == null) {
                    MapPutResult mapPutResult = new MapPutResult(true, key, value, null, null, null);
                    return mapPutResult;
                }
                MapPutResult mapPutResult = new MapPutResult(true, key, value, null, evicted.getKey(), evicted.getValue());
                return mapPutResult;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            MapPutResult mapPutResult = new MapPutResult(false, key, value, record.getValue(), null, null);
            return mapPutResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapPutResult put(ByteBuffer key, ByteBuffer value) {
        this.writeLock.lock();
        try {
            MapCacheRecord evicted = this.evict();
            MapCacheRecord record = new MapCacheRecord(key, value);
            MapCacheRecord existing = this.cache.put(key, record);
            this.inverseCacheMap.put(record, key);
            ByteBuffer existingValue = existing == null ? null : existing.getValue();
            ByteBuffer evictedKey = evicted == null ? null : evicted.getKey();
            ByteBuffer evictedValue = evicted == null ? null : evicted.getValue();
            MapPutResult mapPutResult = new MapPutResult(true, key, value, existingValue, evictedKey, evictedValue);
            return mapPutResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(ByteBuffer key) {
        this.readLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                boolean bl = false;
                return bl;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer get(ByteBuffer key) {
        this.readLock.lock();
        try {
            MapCacheRecord record = this.cache.get(key);
            if (record == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            this.inverseCacheMap.remove(record);
            record.hit();
            this.inverseCacheMap.put(record, key);
            ByteBuffer byteBuffer = record.getValue();
            return byteBuffer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer remove(ByteBuffer key) throws IOException {
        this.writeLock.lock();
        try {
            MapCacheRecord record = this.cache.remove(key);
            if (record == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            this.inverseCacheMap.remove(record);
            ByteBuffer byteBuffer = record.getValue();
            return byteBuffer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void shutdown() throws IOException {
    }
}

