/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.server.AbstractCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.apache.nifi.distributed.cache.server.map.PersistentMapCache;
import org.apache.nifi.distributed.cache.server.map.SimpleMapCache;
import org.apache.nifi.stream.io.DataOutputStream;

public class MapCacheServer
extends AbstractCacheServer {
    private final MapCache cache;

    public MapCacheServer(String identifier, SSLContext sslContext, int port, int maxSize, EvictionPolicy evictionPolicy, File persistencePath) throws IOException {
        super(identifier, sslContext, port);
        SimpleMapCache simpleCache = new SimpleMapCache(identifier, maxSize, evictionPolicy);
        if (persistencePath == null) {
            this.cache = simpleCache;
        } else {
            PersistentMapCache persistentCache = new PersistentMapCache(identifier, persistencePath, simpleCache);
            persistentCache.restore();
            this.cache = persistentCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean listen(InputStream in, OutputStream out, int version) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        DataOutputStream dos = new DataOutputStream(out);
        String action = dis.readUTF();
        try {
            switch (action) {
                case "close": {
                    boolean bl = false;
                    return bl;
                }
                case "putIfAbsent": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    MapPutResult putResult = this.cache.putIfAbsent(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    dos.writeBoolean(putResult.isSuccessful());
                    return true;
                }
                case "put": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    this.cache.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    dos.writeBoolean(true);
                    return true;
                }
                case "containsKey": {
                    byte[] key = this.readValue(dis);
                    boolean contains = this.cache.containsKey(ByteBuffer.wrap(key));
                    dos.writeBoolean(contains);
                    return true;
                }
                case "getAndPutIfAbsent": {
                    byte[] key = this.readValue(dis);
                    byte[] value = this.readValue(dis);
                    MapPutResult putResult = this.cache.putIfAbsent(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
                    if (putResult.isSuccessful()) {
                        dos.writeInt(0);
                        return true;
                    } else {
                        byte[] byteArray = putResult.getExistingValue().array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "get": {
                    byte[] key = this.readValue(dis);
                    ByteBuffer existingValue = this.cache.get(ByteBuffer.wrap(key));
                    if (existingValue == null) {
                        dos.writeInt(0);
                        return true;
                    } else {
                        byte[] byteArray = existingValue.array();
                        dos.writeInt(byteArray.length);
                        dos.write(byteArray);
                        return true;
                    }
                }
                case "remove": {
                    byte[] key = this.readValue(dis);
                    boolean removed = this.cache.remove(ByteBuffer.wrap(key)) != null;
                    dos.writeBoolean(removed);
                    return true;
                }
                default: {
                    throw new IOException("Illegal Request");
                }
            }
        }
        finally {
            dos.flush();
        }
    }

    @Override
    public void stop() throws IOException {
        try {
            super.stop();
        }
        finally {
            this.cache.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
    }

    private byte[] readValue(DataInputStream dis) throws IOException {
        int numBytes = dis.readInt();
        byte[] buffer = new byte[numBytes];
        dis.readFully(buffer);
        return buffer;
    }
}

