/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.server.AbstractCacheServer;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.set.PersistentSetCache;
import org.apache.nifi.distributed.cache.server.set.SetCache;
import org.apache.nifi.distributed.cache.server.set.SetCacheResult;
import org.apache.nifi.distributed.cache.server.set.SimpleSetCache;
import org.apache.nifi.stream.io.DataOutputStream;

public class SetCacheServer
extends AbstractCacheServer {
    private final SetCache cache;

    public SetCacheServer(String identifier, SSLContext sslContext, int port, int maxSize, EvictionPolicy evictionPolicy, File persistencePath) throws IOException {
        super(identifier, sslContext, port);
        SimpleSetCache simpleCache = new SimpleSetCache(identifier, maxSize, evictionPolicy);
        if (persistencePath == null) {
            this.cache = simpleCache;
        } else {
            PersistentSetCache persistentCache = new PersistentSetCache(identifier, persistencePath, simpleCache);
            persistentCache.restore();
            this.cache = persistentCache;
        }
    }

    @Override
    protected boolean listen(InputStream in, OutputStream out, int version) throws IOException {
        SetCacheResult response;
        DataInputStream dis = new DataInputStream(in);
        DataOutputStream dos = new DataOutputStream(out);
        String action = dis.readUTF();
        if (action.equals("close")) {
            return false;
        }
        int valueLength = dis.readInt();
        byte[] value = new byte[valueLength];
        dis.readFully(value);
        ByteBuffer valueBuffer = ByteBuffer.wrap(value);
        switch (action) {
            case "addIfAbsent": {
                response = this.cache.addIfAbsent(valueBuffer);
                break;
            }
            case "contains": {
                response = this.cache.contains(valueBuffer);
                break;
            }
            case "remove": {
                response = this.cache.remove(valueBuffer);
                break;
            }
            default: {
                throw new IOException("IllegalRequest");
            }
        }
        dos.writeBoolean(response.getResult());
        dos.flush();
        return true;
    }

    @Override
    public void stop() throws IOException {
        try {
            super.stop();
        }
        finally {
            this.cache.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
    }
}

