/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.distributed.cache.client.CommsSession;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelInputStream;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelOutputStream;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;

public class SSLCommsSession
implements CommsSession {
    private final SSLSocketChannel sslSocketChannel;
    private final SSLContext sslContext;
    private final String hostname;
    private final int port;
    private final SSLSocketChannelInputStream in;
    private final BufferedInputStream bufferedIn;
    private final SSLSocketChannelOutputStream out;
    private final BufferedOutputStream bufferedOut;
    private int protocolVersion;

    public SSLCommsSession(SSLContext sslContext, String hostname, int port, int timeoutMillis) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.socket().connect(new InetSocketAddress(hostname, port), timeoutMillis);
        socketChannel.configureBlocking(false);
        this.sslSocketChannel = new SSLSocketChannel(sslContext, socketChannel, true);
        this.in = new SSLSocketChannelInputStream(this.sslSocketChannel);
        this.bufferedIn = new BufferedInputStream((InputStream)this.in);
        this.out = new SSLSocketChannelOutputStream(this.sslSocketChannel);
        this.bufferedOut = new BufferedOutputStream((OutputStream)this.out);
        this.sslContext = sslContext;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void interrupt() {
        this.sslSocketChannel.interrupt();
    }

    @Override
    public void close() throws IOException {
        this.sslSocketChannel.close();
    }

    @Override
    public void setTimeout(long value, TimeUnit timeUnit) {
        this.sslSocketChannel.setTimeout((int)TimeUnit.MILLISECONDS.convert(value, timeUnit));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.bufferedIn;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.bufferedOut;
    }

    @Override
    public boolean isClosed() {
        return this.sslSocketChannel.isClosed();
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.sslSocketChannel.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }
}

