/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.nifi.distributed.cache.client.CacheClientHandshakeHandler;
import org.apache.nifi.distributed.cache.client.CacheClientRequestHandler;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.VersionNegotiatorFactory;

public class CacheClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final SSLContext sslContext;
    private final VersionNegotiatorFactory versionNegotiatorFactory;

    public CacheClientChannelInitializer(SSLContext sslContext, VersionNegotiatorFactory factory) {
        this.sslContext = sslContext;
        this.versionNegotiatorFactory = factory;
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        if (this.sslContext != null) {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            SslHandler sslHandler = new SslHandler(sslEngine);
            channelPipeline.addLast(new ChannelHandler[]{sslHandler});
        }
        VersionNegotiator versionNegotiator = this.versionNegotiatorFactory.create();
        channelPipeline.addLast(new ChannelHandler[]{new CacheClientHandshakeHandler(channel, versionNegotiator)});
        channelPipeline.addLast(new ChannelHandler[]{new CacheClientRequestHandler()});
    }
}

