/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.CommsSession;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.SSLCommsSession;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.distributed.cache.client.StandardCommsSession;
import org.apache.nifi.distributed.cache.protocol.ProtocolHandshake;
import org.apache.nifi.distributed.cache.protocol.exception.HandshakeException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.apache.nifi.stream.io.DataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"distributed", "cache", "state", "map", "cluster"})
@SeeAlso(classNames={"org.apache.nifi.distributed.cache.server.map.DistributedMapCacheServer", "org.apache.nifi.ssl.StandardSSLContextService"})
@CapabilityDescription(value="Provides the ability to communicate with a DistributedMapCacheServer. This can be used in order to share a Map between nodes in a NiFi cluster")
public class DistributedMapCacheClientService
extends AbstractControllerService
implements DistributedMapCacheClient {
    private static final Logger logger = LoggerFactory.getLogger(DistributedMapCacheClientService.class);
    public static final PropertyDescriptor HOSTNAME = new PropertyDescriptor.Builder().name("Server Hostname").description("The name of the server that is running the DistributedMapCacheServer service").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Server Port").description("The port on the remote server that is to be used when communicating with the DistributedMapCacheServer service").required(true).addValidator(StandardValidators.PORT_VALIDATOR).defaultValue("4557").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("If specified, indicates the SSL Context Service that is used to communicate with the remote server. If not specified, communications will not be encrypted").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor COMMUNICATIONS_TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("Specifies how long to wait when communicating with the remote server before determining that there is a communications failure if data cannot be sent or received").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    private final BlockingQueue<CommsSession> queue = new LinkedBlockingQueue<CommsSession>();
    private volatile ConfigurationContext configContext;
    private volatile boolean closed = false;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HOSTNAME);
        descriptors.add(PORT);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(COMMUNICATIONS_TIMEOUT);
        return descriptors;
    }

    @OnEnabled
    public void cacheConfig(ConfigurationContext context) {
        this.configContext = context;
    }

    public <K, V> boolean putIfAbsent(final K key, final V value, final Serializer<K> keySerializer, final Serializer<V> valueSerializer) throws IOException {
        return this.withCommsSession(new CommsAction<Boolean>(){

            @Override
            public Boolean execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("putIfAbsent");
                DistributedMapCacheClientService.this.serialize(key, keySerializer, dos);
                DistributedMapCacheClientService.this.serialize(value, valueSerializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                return dis.readBoolean();
            }
        });
    }

    public <K, V> void put(final K key, final V value, final Serializer<K> keySerializer, final Serializer<V> valueSerializer) throws IOException {
        this.withCommsSession(new CommsAction<Object>(){

            @Override
            public Object execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("put");
                DistributedMapCacheClientService.this.serialize(key, keySerializer, dos);
                DistributedMapCacheClientService.this.serialize(value, valueSerializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                boolean success = dis.readBoolean();
                if (!success) {
                    throw new IOException("Expected to receive confirmation of 'put' request but received unexpected response");
                }
                return null;
            }
        });
    }

    public <K> boolean containsKey(final K key, final Serializer<K> keySerializer) throws IOException {
        return this.withCommsSession(new CommsAction<Boolean>(){

            @Override
            public Boolean execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("containsKey");
                DistributedMapCacheClientService.this.serialize(key, keySerializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                return dis.readBoolean();
            }
        });
    }

    public <K, V> V getAndPutIfAbsent(final K key, final V value, final Serializer<K> keySerializer, final Serializer<V> valueSerializer, final Deserializer<V> valueDeserializer) throws IOException {
        return (V)this.withCommsSession(new CommsAction<V>(){

            @Override
            public V execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("getAndPutIfAbsent");
                DistributedMapCacheClientService.this.serialize(key, keySerializer, dos);
                DistributedMapCacheClientService.this.serialize(value, valueSerializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                byte[] responseBuffer = DistributedMapCacheClientService.this.readLengthDelimitedResponse(dis);
                return valueDeserializer.deserialize(responseBuffer);
            }
        });
    }

    public <K, V> V get(final K key, final Serializer<K> keySerializer, final Deserializer<V> valueDeserializer) throws IOException {
        return (V)this.withCommsSession(new CommsAction<V>(){

            @Override
            public V execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("get");
                DistributedMapCacheClientService.this.serialize(key, keySerializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                byte[] responseBuffer = DistributedMapCacheClientService.this.readLengthDelimitedResponse(dis);
                return valueDeserializer.deserialize(responseBuffer);
            }
        });
    }

    public <K> boolean remove(final K key, final Serializer<K> serializer) throws IOException {
        return this.withCommsSession(new CommsAction<Boolean>(){

            @Override
            public Boolean execute(CommsSession session) throws IOException {
                DataOutputStream dos = new DataOutputStream(session.getOutputStream());
                dos.writeUTF("remove");
                DistributedMapCacheClientService.this.serialize(key, serializer, dos);
                dos.flush();
                DataInputStream dis = new DataInputStream(session.getInputStream());
                return dis.readBoolean();
            }
        });
    }

    private byte[] readLengthDelimitedResponse(DataInputStream dis) throws IOException {
        int responseLength = dis.readInt();
        byte[] responseBuffer = new byte[responseLength];
        dis.readFully(responseBuffer);
        return responseBuffer;
    }

    public CommsSession createCommsSession(ConfigurationContext context) throws IOException {
        String hostname = context.getProperty(HOSTNAME).getValue();
        int port = context.getProperty(PORT).asInteger();
        long timeoutMillis = context.getProperty(COMMUNICATIONS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        CommsSession commsSession = sslContextService == null ? new StandardCommsSession(hostname, port) : new SSLCommsSession(sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED), hostname, port);
        commsSession.setTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
        return commsSession;
    }

    private CommsSession leaseCommsSession() throws IOException {
        CommsSession session = (CommsSession)this.queue.poll();
        if (session != null && !session.isClosed()) {
            return session;
        }
        session = this.createCommsSession(this.configContext);
        StandardVersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{1});
        try {
            ProtocolHandshake.initiateHandshake((InputStream)session.getInputStream(), (OutputStream)session.getOutputStream(), (VersionNegotiator)versionNegotiator);
        }
        catch (HandshakeException e) {
            try {
                session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(e);
        }
        return session;
    }

    public void close() throws IOException {
        CommsSession commsSession;
        this.closed = true;
        while ((commsSession = (CommsSession)this.queue.poll()) != null) {
            try {
                DataOutputStream dos = new DataOutputStream(commsSession.getOutputStream());
                Throwable throwable = null;
                try {
                    dos.writeUTF("close");
                    dos.flush();
                    commsSession.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dos == null) continue;
                    if (throwable != null) {
                        try {
                            dos.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    dos.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (logger.isDebugEnabled() && this.getIdentifier() != null) {
            logger.debug("Closed {}", new Object[]{this.getIdentifier()});
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
        logger.debug("Finalize called");
    }

    private <T> void serialize(T value, Serializer<T> serializer, DataOutputStream dos) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize(value, (OutputStream)baos);
        dos.writeInt(baos.size());
        baos.writeTo((OutputStream)dos);
    }

    private <T> T withCommsSession(CommsAction<T> action) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
        boolean tryToRequeue = true;
        CommsSession session = this.leaseCommsSession();
        try {
            T t = action.execute(session);
            return t;
        }
        catch (IOException ioe) {
            tryToRequeue = false;
            throw ioe;
        }
        finally {
            if (tryToRequeue && !this.closed) {
                this.queue.offer(session);
            } else {
                IOUtils.closeQuietly((Closeable)session);
            }
        }
    }

    private static interface CommsAction<T> {
        public T execute(CommsSession var1) throws IOException;
    }
}

