/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.web.NiFiWebRequestContext;
import org.apache.nifi.web.UiExtensionType;

public class HttpServletRequestContext
implements NiFiWebRequestContext {
    private static final String ID_PARAM = "id";
    private final UiExtensionType extensionType;
    private final HttpServletRequest request;

    public HttpServletRequestContext(UiExtensionType extensionType, HttpServletRequest request) {
        this.extensionType = extensionType;
        this.request = request;
    }

    public UiExtensionType getExtensionType() {
        return this.extensionType;
    }

    public String getProxiedEntitiesChain() {
        String xProxiedEntitiesChain = this.request.getHeader("X-ProxiedEntitiesChain");
        X509Certificate cert = this.extractClientCertificate(this.request);
        if (cert != null) {
            String extractedPrincipal = this.extractPrincipal(cert);
            String formattedPrincipal = this.formatProxyDn(extractedPrincipal);
            xProxiedEntitiesChain = xProxiedEntitiesChain == null || xProxiedEntitiesChain.trim().isEmpty() ? formattedPrincipal : xProxiedEntitiesChain + formattedPrincipal;
        }
        return xProxiedEntitiesChain;
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getId() {
        return this.request.getParameter(ID_PARAM);
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private String extractPrincipal(X509Certificate cert) {
        return cert.getSubjectDN().getName().trim();
    }

    private String formatProxyDn(String dn) {
        return "<" + dn + ">";
    }
}

