/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.couchbase;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.couchbase.CouchbaseClusterControllerService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

@CapabilityDescription(value="Provides a centralized Couchbase connection and bucket passwords management. Bucket passwords can be specified via dynamic properties.")
@Tags(value={"nosql", "couchbase", "database", "connection"})
@DynamicProperty(name="Bucket Password for BUCKET_NAME", value="bucket password", description="Specify bucket password if necessary.")
public class CouchbaseClusterService
extends AbstractControllerService
implements CouchbaseClusterControllerService {
    public static final PropertyDescriptor CONNECTION_STRING = new PropertyDescriptor.Builder().name("Connection String").description("The hostnames or ip addresses of the bootstraping nodes and optional parameters. Syntax) couchbase://node1,node2,nodeN?param1=value1&param2=value2&paramN=valueN").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties;
    private static final String DYNAMIC_PROP_BUCKET_PASSWORD = "Bucket Password for ";
    private static final Map<String, String> bucketPasswords;
    private volatile CouchbaseCluster cluster;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith(DYNAMIC_PROP_BUCKET_PASSWORD)) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("Bucket password.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).sensitive(true).build();
        }
        return null;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        for (PropertyDescriptor p : context.getProperties().keySet()) {
            if (!p.isDynamic() || !p.getName().startsWith(DYNAMIC_PROP_BUCKET_PASSWORD)) continue;
            String bucketName = p.getName().substring(DYNAMIC_PROP_BUCKET_PASSWORD.length());
            String password = context.getProperty(p).getValue();
            bucketPasswords.put(bucketName, password);
        }
        try {
            this.cluster = CouchbaseCluster.fromConnectionString((String)context.getProperty(CONNECTION_STRING).getValue());
        }
        catch (CouchbaseException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public Bucket openBucket(String bucketName) {
        return this.cluster.openBucket(bucketName, bucketPasswords.get(bucketName));
    }

    @OnDisabled
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.disconnect();
            this.cluster = null;
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(CONNECTION_STRING);
        properties = Collections.unmodifiableList(props);
        bucketPasswords = new HashMap<String, String>();
    }
}

