/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.AbstractEventWriter;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.event.io.FlowFileEventWriteStrategy;
import org.apache.nifi.cdc.mysql.event.BinlogEventInfo;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.exception.ProcessException;

public abstract class AbstractBinlogEventWriter<T extends BinlogEventInfo>
extends AbstractEventWriter<T> {
    protected void writeJson(T event) throws IOException {
        String gtidSet = event.getBinlogGtidSet();
        if (gtidSet == null) {
            this.jsonGenerator.writeStringField("binlog_filename", event.getBinlogFilename());
            this.jsonGenerator.writeNumberField("binlog_position", event.getBinlogPosition().longValue());
        } else {
            this.jsonGenerator.writeStringField("binlog_gtidset", event.getBinlogGtidSet());
        }
    }

    protected Map<String, String> getCommonAttributes(long sequenceId, BinlogEventInfo eventInfo) {
        HashMap<String, String> commonAttributeMap = new HashMap<String, String>();
        commonAttributeMap.put("cdc.sequence.id", Long.toString(sequenceId));
        commonAttributeMap.put("cdc.event.type", eventInfo.getEventType());
        String gtidSet = eventInfo.getBinlogGtidSet();
        if (gtidSet == null) {
            commonAttributeMap.put("binlog.filename", eventInfo.getBinlogFilename());
            commonAttributeMap.put("binlog.position", Long.toString(eventInfo.getBinlogPosition()));
        } else {
            commonAttributeMap.put("binlog.gtidset", gtidSet);
        }
        commonAttributeMap.put(CoreAttributes.MIME_TYPE.key(), "application/json");
        return commonAttributeMap;
    }

    public long writeEvent(ProcessSession session, String transitUri, T eventInfo, long currentSequenceId, Relationship relationship, EventWriterConfiguration eventWriterConfiguration) {
        this.configureEventWriter(eventWriterConfiguration, session, (EventInfo)eventInfo);
        OutputStream outputStream = eventWriterConfiguration.getFlowFileOutputStream();
        try {
            super.startJson(outputStream, eventInfo);
            this.writeJson(eventInfo);
            super.endJson();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Write JSON start array failed", ioe);
        }
        eventWriterConfiguration.incrementNumberOfEventsWritten();
        if (this.maxEventsPerFlowFile(eventWriterConfiguration) && eventWriterConfiguration.getNumberOfEventsWritten() == eventWriterConfiguration.getNumberOfEventsPerFlowFile()) {
            this.finishAndTransferFlowFile(session, eventWriterConfiguration, transitUri, currentSequenceId, (BinlogEventInfo)eventInfo, relationship);
        }
        return currentSequenceId + 1L;
    }

    public void finishAndTransferFlowFile(ProcessSession session, EventWriterConfiguration eventWriterConfiguration, String transitUri, long seqId, BinlogEventInfo eventInfo, Relationship relationship) {
        if (this.writtenMultipleEvents(eventWriterConfiguration)) {
            try {
                this.jsonGenerator.writeEndArray();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Write JSON end array failed", ioe);
            }
        }
        try {
            this.endFile();
            FlowFile flowFile = eventWriterConfiguration.getCurrentFlowFile();
            if (session == null || flowFile == null) {
                throw new ProcessException("No open FlowFile or ProcessSession to write to");
            }
            flowFile = session.putAllAttributes(flowFile, this.getCommonAttributes(seqId, eventInfo));
            session.transfer(flowFile, relationship);
            session.getProvenanceReporter().receive(flowFile, transitUri);
            eventWriterConfiguration.cleanUp();
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Failed to close event writer", (Throwable)ioe);
        }
    }

    protected void configureEventWriter(EventWriterConfiguration eventWriterConfiguration, ProcessSession session, EventInfo eventInfo) {
        FlowFile flowFile = eventWriterConfiguration.getCurrentFlowFile();
        if (flowFile == null) {
            flowFile = session.create();
            OutputStream flowFileOutputStream = session.write(flowFile);
            if (eventWriterConfiguration.getJsonGenerator() == null) {
                try {
                    this.jsonGenerator = this.createJsonGenerator(flowFileOutputStream);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("JSON Generator creation failed", ioe);
                }
            }
            if (this.multipleEventsPerFlowFile(eventWriterConfiguration)) {
                try {
                    this.jsonGenerator.writeStartArray();
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("Write JSON start array failed", ioe);
                }
            }
            eventWriterConfiguration.startNewFlowFile(flowFile, flowFileOutputStream, this.jsonGenerator);
        }
        this.jsonGenerator = eventWriterConfiguration.getJsonGenerator();
    }

    private boolean multipleEventsPerFlowFile(EventWriterConfiguration eventWriterConfiguration) {
        return this.maxEventsPerFlowFile(eventWriterConfiguration) && eventWriterConfiguration.getNumberOfEventsPerFlowFile() > 1 || this.oneTransactionPerFlowFile(eventWriterConfiguration);
    }

    private boolean writtenMultipleEvents(EventWriterConfiguration eventWriterConfiguration) {
        return eventWriterConfiguration.getNumberOfEventsWritten() > 1 || this.oneTransactionPerFlowFile(eventWriterConfiguration);
    }

    protected boolean maxEventsPerFlowFile(EventWriterConfiguration eventWriterConfiguration) {
        return FlowFileEventWriteStrategy.MAX_EVENTS_PER_FLOWFILE.equals((Object)eventWriterConfiguration.getFlowFileEventWriteStrategy());
    }

    protected boolean oneTransactionPerFlowFile(EventWriterConfiguration eventWriterConfiguration) {
        return FlowFileEventWriteStrategy.ONE_TRANSACTION_PER_FLOWFILE.equals((Object)eventWriterConfiguration.getFlowFileEventWriteStrategy());
    }
}

