/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.mysql.event.InsertRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.MySQLCDCUtils;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogTableEventWriter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class InsertRowsWriter
extends AbstractBinlogTableEventWriter<InsertRowsEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, InsertRowsEventInfo eventInfo, long currentSequenceId, Relationship relationship) {
        AtomicLong seqId = new AtomicLong(currentSequenceId);
        for (Serializable[] row : eventInfo.getRows()) {
            FlowFile flowFile = session.create();
            flowFile = session.write(flowFile, outputStream -> {
                super.startJson(outputStream, (EventInfo)eventInfo);
                super.writeJson(eventInfo);
                BitSet bitSet = eventInfo.getIncludedColumns();
                this.writeRow(eventInfo, row, bitSet);
                super.endJson();
            });
            flowFile = session.putAllAttributes(flowFile, this.getCommonAttributes(seqId.get(), eventInfo));
            session.transfer(flowFile, relationship);
            session.getProvenanceReporter().receive(flowFile, transitUri);
            seqId.getAndIncrement();
        }
        return seqId.get();
    }

    protected void writeRow(InsertRowsEventInfo event, Serializable[] row, BitSet includedColumns) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("columns");
        int i = includedColumns.nextSetBit(0);
        while (i != -1) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("id", i + 1);
            ColumnDefinition columnDefinition = event.getColumnByIndex(i);
            Integer columnType = null;
            if (columnDefinition != null) {
                this.jsonGenerator.writeStringField("name", columnDefinition.getName());
                columnType = columnDefinition.getType();
                this.jsonGenerator.writeNumberField("column_type", columnType.intValue());
            }
            if (row[i] == null) {
                this.jsonGenerator.writeNullField("value");
            } else {
                this.jsonGenerator.writeObjectField("value", MySQLCDCUtils.getWritableObject(columnType, row[i]));
            }
            this.jsonGenerator.writeEndObject();
            i = includedColumns.nextSetBit(i + 1);
        }
        this.jsonGenerator.writeEndArray();
    }
}

