/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.BitSet;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.DeleteRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.MySQLCDCUtils;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogTableEventWriter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class DeleteRowsWriter
extends AbstractBinlogTableEventWriter<DeleteRowsEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, DeleteRowsEventInfo eventInfo, long currentSequenceId, Relationship relationship, EventWriterConfiguration eventWriterConfiguration) {
        long seqId = currentSequenceId;
        for (Serializable[] row : eventInfo.getRows()) {
            this.configureEventWriter(eventWriterConfiguration, session, eventInfo);
            OutputStream outputStream = eventWriterConfiguration.getFlowFileOutputStream();
            try {
                super.startJson(outputStream, (EventInfo)eventInfo);
                super.writeJson(eventInfo);
                BitSet bitSet = eventInfo.getIncludedColumns();
                this.writeRow(eventInfo, row, bitSet);
                super.endJson();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Write JSON start array failed", ioe);
            }
            eventWriterConfiguration.incrementNumberOfEventsWritten();
            if (this.maxEventsPerFlowFile(eventWriterConfiguration) && eventWriterConfiguration.getNumberOfEventsWritten() == eventWriterConfiguration.getNumberOfEventsPerFlowFile()) {
                this.finishAndTransferFlowFile(session, eventWriterConfiguration, transitUri, seqId, eventInfo, relationship);
            }
            ++seqId;
        }
        return seqId;
    }

    protected void writeRow(DeleteRowsEventInfo event, Serializable[] row, BitSet includedColumns) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("columns");
        int i = includedColumns.nextSetBit(0);
        while (i != -1) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("id", i + 1);
            ColumnDefinition columnDefinition = event.getColumnByIndex(i);
            Integer columnType = null;
            if (columnDefinition != null) {
                this.jsonGenerator.writeStringField("name", columnDefinition.getName());
                columnType = columnDefinition.getType();
                this.jsonGenerator.writeNumberField("column_type", columnType.intValue());
            }
            if (row[i] == null) {
                this.jsonGenerator.writeNullField("value");
            } else {
                this.jsonGenerator.writeObjectField("value", MySQLCDCUtils.getWritableObject(columnType, row[i]));
            }
            this.jsonGenerator.writeEndObject();
            i = includedColumns.nextSetBit(i + 1);
        }
        this.jsonGenerator.writeEndArray();
    }
}

