/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.mysql.event.BinlogEventInfo;
import org.apache.nifi.cdc.mysql.event.BinlogTableEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogEventWriter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public abstract class AbstractBinlogTableEventWriter<T extends BinlogTableEventInfo>
extends AbstractBinlogEventWriter<T> {
    @Override
    protected void writeJson(T event) throws IOException {
        super.writeJson(event);
        if (event.getDatabaseName() != null) {
            this.jsonGenerator.writeStringField("database", event.getDatabaseName());
        } else {
            this.jsonGenerator.writeNullField("database");
        }
        if (event.getTableName() != null) {
            this.jsonGenerator.writeStringField("table_name", event.getTableName());
        } else {
            this.jsonGenerator.writeNullField("table_name");
        }
        if (event.getTableId() != null) {
            this.jsonGenerator.writeNumberField("table_id", event.getTableId().longValue());
        } else {
            this.jsonGenerator.writeNullField("table_id");
        }
    }

    @Override
    public long writeEvent(ProcessSession session, String transitUri, T eventInfo, long currentSequenceId, Relationship relationship) {
        FlowFile flowFile = session.create();
        flowFile = session.write(flowFile, outputStream -> {
            super.startJson(outputStream, (EventInfo)eventInfo);
            this.writeJson(eventInfo);
            super.endJson();
        });
        flowFile = session.putAllAttributes(flowFile, this.getCommonAttributes(currentSequenceId, (BinlogEventInfo)eventInfo));
        session.transfer(flowFile, relationship);
        session.getProvenanceReporter().receive(flowFile, transitUri);
        return currentSequenceId + 1L;
    }
}

