/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.cassandra.CassandraSessionProviderService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.cassandra.QueryUtils;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"map", "cache", "distributed", "cassandra"})
@CapabilityDescription(value="Provides a DistributedMapCache client that is based on Apache Cassandra.")
public class CassandraDistributedMapCache
extends AbstractControllerService
implements DistributedMapCacheClient {
    public static final PropertyDescriptor SESSION_PROVIDER = new PropertyDescriptor.Builder().name("cassandra-dmc-session-provider").displayName("Session Provider").description("The client service that will configure the cassandra client connection.").required(true).identifiesControllerService(CassandraSessionProviderService.class).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("cassandra-dmc-table-name").displayName("Table Name").description("The name of the table where the cache will be stored.").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor KEY_FIELD_NAME = new PropertyDescriptor.Builder().name("cassandra-dmc-key-field-name").displayName("Key Field Name").description("The name of the field that acts as the unique key. (The CQL type should be \"blob\")").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor VALUE_FIELD_NAME = new PropertyDescriptor.Builder().name("cassandra-dmc-value-field-name").displayName("Value Field Name").description("The name of the field that will store the value. (The CQL type should be \"blob\")").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor TTL = new PropertyDescriptor.Builder().name("cassandra-dmc-ttl").displayName("TTL").description("If configured, this will set a TTL (Time to Live) for each row inserted into the table so that old cache items expire after a certain period of time.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).build();
    public static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(SESSION_PROVIDER, TABLE_NAME, KEY_FIELD_NAME, VALUE_FIELD_NAME, TTL));
    private CassandraSessionProviderService sessionProviderService;
    private String tableName;
    private String keyField;
    private String valueField;
    private Long ttl;
    private Session session;
    private PreparedStatement deleteStatement;
    private PreparedStatement existsStatement;
    private PreparedStatement fetchStatement;
    private PreparedStatement insertStatement;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.sessionProviderService = (CassandraSessionProviderService)context.getProperty(SESSION_PROVIDER).asControllerService(CassandraSessionProviderService.class);
        this.tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions().getValue();
        this.keyField = context.getProperty(KEY_FIELD_NAME).evaluateAttributeExpressions().getValue();
        this.valueField = context.getProperty(VALUE_FIELD_NAME).evaluateAttributeExpressions().getValue();
        if (context.getProperty(TTL).isSet()) {
            this.ttl = context.getProperty(TTL).evaluateAttributeExpressions().asTimePeriod(TimeUnit.SECONDS);
        }
        this.session = this.sessionProviderService.getCassandraSession();
        this.deleteStatement = this.session.prepare(QueryUtils.createDeleteStatement(this.keyField, this.tableName));
        this.existsStatement = this.session.prepare(QueryUtils.createExistsQuery(this.keyField, this.tableName));
        this.fetchStatement = this.session.prepare(QueryUtils.createFetchQuery(this.keyField, this.valueField, this.tableName));
        this.insertStatement = this.session.prepare(QueryUtils.createInsertStatement(this.keyField, this.valueField, this.tableName, this.ttl));
    }

    @OnDisabled
    public void onDisabled() {
        this.session = null;
        this.deleteStatement = null;
        this.existsStatement = null;
        this.fetchStatement = null;
        this.insertStatement = null;
    }

    public <K, V> boolean putIfAbsent(K k, V v, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        if (this.containsKey(k, keySerializer)) {
            return false;
        }
        this.put(k, v, keySerializer, valueSerializer);
        return true;
    }

    public <K, V> V getAndPutIfAbsent(K k, V v, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> deserializer) throws IOException {
        V got = this.get(k, keySerializer, deserializer);
        boolean wasAbsent = this.putIfAbsent(k, v, keySerializer, valueSerializer);
        return (V)(!wasAbsent ? got : null);
    }

    public <K> boolean containsKey(K k, Serializer<K> serializer) throws IOException {
        byte[] key = this.serializeKey(k, serializer);
        BoundStatement statement = this.existsStatement.bind();
        ByteBuffer buffer = ByteBuffer.wrap(key);
        statement.setBytes(0, buffer);
        ResultSet rs = this.session.execute((Statement)statement);
        Iterator iterator = rs.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            long value = row.getLong("exist_count");
            return value > 0L;
        }
        return false;
    }

    public <K, V> void put(K k, V v, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        BoundStatement statement = this.insertStatement.bind();
        statement.setBytes(0, ByteBuffer.wrap(this.serializeKey(k, keySerializer)));
        statement.setBytes(1, ByteBuffer.wrap(this.serializeValue(v, valueSerializer)));
        this.session.execute((Statement)statement);
    }

    public <K, V> V get(K k, Serializer<K> serializer, Deserializer<V> deserializer) throws IOException {
        BoundStatement boundStatement = this.fetchStatement.bind();
        boundStatement.setBytes(0, ByteBuffer.wrap(this.serializeKey(k, serializer)));
        ResultSet rs = this.session.execute((Statement)boundStatement);
        Iterator iterator = rs.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Row fetched = (Row)iterator.next();
        ByteBuffer buffer = fetched.getBytes(this.valueField);
        byte[] content = buffer.array();
        return (V)deserializer.deserialize(content);
    }

    public void close() throws IOException {
    }

    public <K> boolean remove(K k, Serializer<K> serializer) throws IOException {
        BoundStatement delete = this.deleteStatement.bind();
        delete.setBytes(0, ByteBuffer.wrap(this.serializeKey(k, serializer)));
        this.session.execute((Statement)delete);
        return true;
    }

    private <K> byte[] serializeKey(K k, Serializer<K> keySerializer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        keySerializer.serialize(k, (OutputStream)out);
        out.close();
        return out.toByteArray();
    }

    private <V> byte[] serializeValue(V v, Serializer<V> valueSerializer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        valueSerializer.serialize(v, (OutputStream)out);
        out.close();
        return out.toByteArray();
    }
}

