/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.Metadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.BoxMetadataJsonArrayWriter;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.FetchBoxFileInfo;
import org.apache.nifi.processors.box.ListBoxFile;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "templates"})
@CapabilityDescription(value="Retrieves all metadata templates associated with a Box file.")
@SeeAlso(value={ListBoxFile.class, FetchBoxFile.class, FetchBoxFileInfo.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.file.id", description="The ID of the file from which metadata was fetched"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile"), @WritesAttribute(attribute="mime.type", description="The MIME Type specified by the Record Writer"), @WritesAttribute(attribute="box.metadata.templates.names", description="Comma-separated list of template names"), @WritesAttribute(attribute="box.metadata.templates.count", description="Number of metadata templates found"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class ListBoxFileMetadataTemplates
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file for which to fetch metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing the metadata template records will be routed to this relationship upon successful processing.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here if there is an error fetching metadata templates from the file.").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FILE_ID);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            ArrayList templatesList = new ArrayList();
            Iterable metadataList = boxFile.getAllMetadata(new String[0]);
            Iterator iterator = metadataList.iterator();
            LinkedHashSet<String> templateNames = new LinkedHashSet<String>();
            if (!iterator.hasNext()) {
                flowFile = session.putAttribute(flowFile, "box.file.id", fileId);
                flowFile = session.putAttribute(flowFile, "box.metadata.templates.count", "0");
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
            while (iterator.hasNext()) {
                Metadata metadata = (Metadata)iterator.next();
                HashMap<String, Object> templateFields = new HashMap<String, Object>();
                templateNames.add(metadata.getTemplateName());
                templateFields.put("$id", metadata.getID());
                templateFields.put("$type", metadata.getTypeName());
                templateFields.put("$parent", "file_" + fileId);
                templateFields.put("$template", metadata.getTemplateName());
                templateFields.put("$scope", metadata.getScope());
                for (String string : metadata.getPropertyPaths()) {
                    if (metadata.getValue(string) == null) continue;
                    String cleanFieldName = string.startsWith("/") ? string.substring(1) : string;
                    String fieldValue = metadata.getValue(string).asString();
                    templateFields.put(cleanFieldName, fieldValue);
                }
                templatesList.add(templateFields);
            }
            try {
                try (OutputStream out = session.write(flowFile);
                     BoxMetadataJsonArrayWriter writer = BoxMetadataJsonArrayWriter.create(out);){
                    for (Map map : templatesList) {
                        writer.write(map);
                    }
                }
                HashMap<String, String> recordAttributes = new HashMap<String, String>();
                recordAttributes.put("record.count", String.valueOf(templatesList.size()));
                recordAttributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
                recordAttributes.put("box.file.id", fileId);
                recordAttributes.put("box.metadata.templates.names", String.join((CharSequence)",", templateNames));
                recordAttributes.put("box.metadata.templates.count", String.valueOf(templatesList.size()));
                flowFile = session.putAllAttributes(flowFile, recordAttributes);
                session.getProvenanceReporter().receive(flowFile, "https://app.box.com/file/" + fileId);
                session.transfer(flowFile, REL_SUCCESS);
            }
            catch (IOException e) {
                this.getLogger().error("Failed writing metadata templates from file [{}]", new Object[]{fileId, e});
                flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                session.transfer(flowFile, REL_NOT_FOUND);
            } else {
                this.getLogger().error("Couldn't fetch metadata templates from file with id [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to process metadata templates for file [{}]", new Object[]{fileId, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }
}

