/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.protocol;

import java.util.Arrays;
import java.util.Optional;
import org.apache.nifi.processors.beats.protocol.ProtocolCodeDecoder;
import org.apache.nifi.processors.beats.protocol.ProtocolException;
import org.apache.nifi.processors.beats.protocol.ProtocolVersion;

public class ProtocolVersionDecoder
implements ProtocolCodeDecoder<ProtocolVersion> {
    @Override
    public ProtocolVersion readProtocolCode(byte code) {
        Optional<ProtocolVersion> protocolVersionFound = Arrays.stream(ProtocolVersion.values()).filter(protocolVersion -> protocolVersion.getCode() == code).findFirst();
        return protocolVersionFound.orElseThrow(() -> {
            String message = String.format("Version Code [%d] not supported", code);
            return new ProtocolException(message);
        });
    }
}

