/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.protocol;

import java.util.Arrays;
import java.util.Optional;
import org.apache.nifi.processors.beats.protocol.FrameType;
import org.apache.nifi.processors.beats.protocol.ProtocolCodeDecoder;
import org.apache.nifi.processors.beats.protocol.ProtocolException;

public class FrameTypeDecoder
implements ProtocolCodeDecoder<FrameType> {
    @Override
    public FrameType readProtocolCode(byte code) {
        Optional<FrameType> frameTypeFound = Arrays.stream(FrameType.values()).filter(frameType -> frameType.getCode() == code).findFirst();
        return frameTypeFound.orElseThrow(() -> {
            String message = String.format("Frame Type Code [%d] not supported", code);
            return new ProtocolException(message);
        });
    }
}

