/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.beats.protocol.FrameType;
import org.apache.nifi.processors.beats.protocol.MessageAck;
import org.apache.nifi.processors.beats.protocol.ProtocolVersion;

@ChannelHandler.Sharable
public class MessageAckEncoder
extends MessageToByteEncoder<MessageAck> {
    private final ComponentLog log;

    public MessageAckEncoder(ComponentLog log) {
        this.log = Objects.requireNonNull(log, "Component Log required");
    }

    protected void encode(ChannelHandlerContext context, MessageAck messageAck, ByteBuf buffer) {
        buffer.writeByte(ProtocolVersion.VERSION_2.getCode());
        buffer.writeByte(FrameType.ACK.getCode());
        int sequenceNumber = messageAck.getSequenceNumber();
        buffer.writeInt(sequenceNumber);
        Channel channel = context.channel();
        this.log.debug("Encoded Message Ack Sequence Number [{}] Local [{}] Remote [{}]", new Object[]{sequenceNumber, channel.localAddress(), channel.remoteAddress()});
    }
}

