/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.frame;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.beats.frame.BeatsFrame;
import org.apache.nifi.processors.beats.frame.BeatsFrameException;
import org.apache.nifi.processors.beats.frame.BeatsState;

public class BeatsDecoder {
    final ComponentLog logger;
    private BeatsFrame.Builder frameBuilder;
    private BeatsState currState = BeatsState.VERSION;
    private byte decodedFrameType;
    private byte[] unprocessedData;
    private final Charset charset;
    private final ByteArrayOutputStream currBytes;
    private long windowSize;
    static final int MIN_FRAME_HEADER_LENGTH = 2;
    static final int WINDOWSIZE_LENGTH = 6;
    static final int COMPRESSED_MIN_LENGTH = 6;
    static final int JSON_MIN_LENGTH = 10;
    public static final byte FRAME_WINDOWSIZE = 87;
    public static final byte FRAME_DATA = 68;
    public static final byte FRAME_COMPRESSED = 67;
    public static final byte FRAME_ACK = 65;
    public static final byte FRAME_JSON = 74;

    public BeatsDecoder(Charset charset, ComponentLog logger) {
        this(charset, new ByteArrayOutputStream(4096), logger);
    }

    public BeatsDecoder(Charset charset, ByteArrayOutputStream buffer, ComponentLog logger) {
        this.logger = logger;
        this.charset = charset;
        this.currBytes = buffer;
        this.frameBuilder = new BeatsFrame.Builder();
        this.decodedFrameType = 0;
    }

    public void reset() {
        this.frameBuilder = new BeatsFrame.Builder();
        this.currState = BeatsState.VERSION;
        this.decodedFrameType = 0;
        this.currBytes.reset();
    }

    public boolean process(byte currByte) throws BeatsFrameException {
        try {
            switch (this.currState) {
                case VERSION: {
                    this.processVERSION(currByte);
                    break;
                }
                case FRAMETYPE: {
                    this.processFRAMETYPE(currByte);
                    break;
                }
                case PAYLOAD: {
                    this.processPAYLOAD(currByte);
                    if (this.frameBuilder.frameType == 87 && this.currState == BeatsState.COMPLETE) {
                        return true;
                    }
                    if (this.frameBuilder.frameType == 67 && this.currState == BeatsState.COMPLETE) {
                        return true;
                    }
                    if (this.frameBuilder.frameType != 74 || this.currState != BeatsState.COMPLETE) break;
                    return true;
                }
                case COMPLETE: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new BeatsFrameException("Error decoding Beats frame: " + e.getMessage(), e);
        }
    }

    public List<BeatsFrame> getFrames() throws BeatsFrameException {
        List<BeatsFrame> frames = new LinkedList<BeatsFrame>();
        if (this.currState != BeatsState.COMPLETE) {
            throw new BeatsFrameException("Must be at the trailer of a frame");
        }
        try {
            if (this.currState == BeatsState.COMPLETE && this.frameBuilder.frameType == 67) {
                this.logger.debug("Frame is compressed, will iterate to decode", new Object[0]);
                this.currBytes.reset();
                this.frameBuilder.reset();
                this.currState = BeatsState.VERSION;
                frames = this.splitCompressedFrames(this.unprocessedData);
            } else {
                BeatsFrame frame = this.frameBuilder.build();
                this.currBytes.reset();
                this.frameBuilder.reset();
                this.currState = BeatsState.VERSION;
                frames.add(frame);
            }
            return frames;
        }
        catch (Exception e) {
            throw new BeatsFrameException("Error decoding Beats frame: " + e.getMessage(), e);
        }
    }

    private List<BeatsFrame> splitCompressedFrames(byte[] decompressedData) {
        LinkedList<BeatsFrame> frames = new LinkedList<BeatsFrame>();
        BeatsFrame.Builder internalFrameBuilder = new BeatsFrame.Builder();
        ByteBuffer currentData = ByteBuffer.wrap(decompressedData);
        while (currentData.hasRemaining()) {
            int payloadLength = 0;
            internalFrameBuilder.version = currentData.get();
            internalFrameBuilder.frameType = currentData.get();
            switch (internalFrameBuilder.frameType) {
                case 74: {
                    internalFrameBuilder.seqNumber = (int)((long)currentData.getInt() & 0xFFFFFFFFL);
                    currentData.mark();
                    internalFrameBuilder.dataSize = (long)currentData.getInt() & 0xFFFFFFFFL;
                    currentData.mark();
                    payloadLength = Math.toIntExact(internalFrameBuilder.dataSize);
                    byte[] jsonBytes = new byte[payloadLength];
                    currentData.get(jsonBytes, 0, payloadLength);
                    currentData.mark();
                    internalFrameBuilder.payload(jsonBytes);
                }
            }
            BeatsFrame frame = internalFrameBuilder.build();
            frames.add(frame);
            internalFrameBuilder.reset();
        }
        return frames;
    }

    private void processVERSION(byte b) {
        byte version = b;
        this.frameBuilder.version(version);
        this.logger.debug("Version number is {}", new Object[]{version});
        this.currBytes.write(b);
        this.currState = BeatsState.FRAMETYPE;
    }

    private void processFRAMETYPE(byte b) {
        this.decodedFrameType = b;
        this.frameBuilder.frameType(this.decodedFrameType);
        this.logger.debug("Frame type is {}", new Object[]{this.decodedFrameType});
        this.currBytes.write(b);
        this.currState = BeatsState.PAYLOAD;
    }

    private void processPAYLOAD(byte b) {
        this.currBytes.write(b);
        switch (this.decodedFrameType) {
            case 87: {
                if (this.currBytes.size() < 6) {
                    this.logger.trace("Beats currBytes contents are {}", new Object[]{this.currBytes.toString()});
                    break;
                }
                if (this.currBytes.size() == 6) {
                    this.frameBuilder.dataSize = (long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 2, 6)).getInt() & 0xFFFFFFFFL;
                    this.logger.debug("Data size is {}", new Object[]{this.frameBuilder.dataSize});
                    this.frameBuilder.payload(new byte[0]);
                    this.currBytes.reset();
                    this.currState = BeatsState.COMPLETE;
                    this.windowSize = this.frameBuilder.dataSize;
                    break;
                }
                this.logger.debug("Saw a packet I should not have seen. Packet contents were {}", new Object[]{this.currBytes.toString()});
                break;
            }
            case 67: {
                if (this.currBytes.size() < 6) {
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace("Beats currBytes contents are {}", new Object[]{this.currBytes.toString()});
                    break;
                }
                if (this.currBytes.size() >= 6) {
                    this.frameBuilder.dataSize = (long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 2, 6)).getInt() & 0xFFFFFFFFL;
                    if ((long)(this.currBytes.size() - 6) != this.frameBuilder.dataSize) break;
                    try {
                        int len;
                        byte[] buf = Arrays.copyOfRange(this.currBytes.toByteArray(), 6, this.currBytes.size());
                        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = ((InputStream)in).read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        ((InputStream)in).close();
                        out.close();
                        this.unprocessedData = out.toByteArray();
                        buf = null;
                        this.logger.debug("Finished decompressing data");
                        this.frameBuilder.dataSize(this.unprocessedData.length);
                        this.currState = BeatsState.COMPLETE;
                        break;
                    }
                    catch (IOException e) {
                        throw new BeatsFrameException("Error decompressing  frame: " + e.getMessage(), e);
                    }
                }
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("Received a compressed frame with partial data or invalid content. The packet contents were {}", new Object[]{this.currBytes.toString()});
                break;
            }
            case 74: {
                if (this.currBytes.size() < 10) {
                    if (!this.logger.isTraceEnabled()) break;
                    this.logger.trace("Beats currBytes contents are {}", new Object[]{this.currBytes.toString()});
                    break;
                }
                if (this.currBytes.size() == 10) {
                    this.frameBuilder.seqNumber = (int)((long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 2, 6)).getInt() & 0xFFFFFFFFL);
                    this.frameBuilder.dataSize = (long)ByteBuffer.wrap(Arrays.copyOfRange(this.currBytes.toByteArray(), 6, 10)).getInt() & 0xFFFFFFFFL;
                    break;
                }
                if (this.currBytes.size() <= 10 || (long)(this.currBytes.size() - 10) != this.frameBuilder.dataSize) break;
                this.frameBuilder.payload = Arrays.copyOfRange(this.currBytes.toByteArray(), 10, this.currBytes.size());
                this.currState = BeatsState.COMPLETE;
            }
        }
    }
}

