/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.security;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.atlas.AtlasClientV2;
import org.apache.nifi.atlas.reporting.ReportLineageToAtlas;
import org.apache.nifi.atlas.security.AtlasAuthN;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.util.StringUtils;

public class Basic
implements AtlasAuthN {
    private String user;
    private String password;

    @Override
    public Collection<ValidationResult> validate(ValidationContext context) {
        return Stream.of(this.validateRequiredField(context, ReportLineageToAtlas.ATLAS_USER), this.validateRequiredField(context, ReportLineageToAtlas.ATLAS_PASSWORD)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public void configure(PropertyContext context) {
        this.user = context.getProperty(ReportLineageToAtlas.ATLAS_USER).evaluateAttributeExpressions().getValue();
        this.password = context.getProperty(ReportLineageToAtlas.ATLAS_PASSWORD).evaluateAttributeExpressions().getValue();
        if (StringUtils.isEmpty((String)this.user)) {
            throw new IllegalArgumentException("User is required for basic auth.");
        }
        if (StringUtils.isEmpty((String)this.password)) {
            throw new IllegalArgumentException("Password is required for basic auth.");
        }
    }

    @Override
    public AtlasClientV2 createClient(String[] baseUrls) {
        return new AtlasClientV2(baseUrls, new String[]{this.user, this.password});
    }
}

