/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.atlas.resolver.NamespaceResolver;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;

public class NamespaceResolvers
implements NamespaceResolver {
    private final Set<NamespaceResolver> resolvers;
    private final String defaultNamespace;

    public NamespaceResolvers(Set<NamespaceResolver> resolvers, String defaultNamespace) {
        this.resolvers = resolvers;
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        for (NamespaceResolver resolver : this.resolvers) {
            PropertyDescriptor descriptor = resolver.getSupportedDynamicPropertyDescriptor(propertyDescriptorName);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (NamespaceResolver resolver : this.resolvers) {
            results.addAll(resolver.validate(validationContext));
        }
        return results;
    }

    @Override
    public void configure(PropertyContext context) {
        for (NamespaceResolver resolver : this.resolvers) {
            resolver.configure(context);
        }
    }

    @Override
    public String fromHostNames(String ... hostNames) {
        for (NamespaceResolver resolver : this.resolvers) {
            String namespace = resolver.fromHostNames(hostNames);
            if (namespace == null || namespace.isEmpty()) continue;
            return namespace;
        }
        return this.defaultNamespace;
    }

    @Override
    public String fromHints(Map<String, String> hints) {
        for (NamespaceResolver resolver : this.resolvers) {
            String namespace = resolver.fromHints(hints);
            if (namespace == null || namespace.isEmpty()) continue;
            return namespace;
        }
        return this.defaultNamespace;
    }
}

