/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.lineage;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;

public class LineagePath {
    private List<ProvenanceEventRecord> events = new ArrayList<ProvenanceEventRecord>();
    private List<LineagePath> parents = new ArrayList<LineagePath>();
    private DataSetRefs refs;
    private long lineagePathHash;

    public List<ProvenanceEventRecord> getEvents() {
        return this.events;
    }

    public List<LineagePath> getParents() {
        return this.parents;
    }

    public DataSetRefs getRefs() {
        return this.refs;
    }

    public void setRefs(DataSetRefs refs) {
        this.refs = refs;
    }

    public boolean shouldCreateSeparatePath(ProvenanceEventType eventType) {
        switch (eventType) {
            case CLONE: 
            case JOIN: 
            case FORK: 
            case REPLAY: {
                return true;
            }
        }
        return false;
    }

    public boolean isComplete() {
        boolean isDroppedImmediately = this.events.size() == 2 && this.events.get(0).getEventType().equals((Object)ProvenanceEventType.DROP) && this.shouldCreateSeparatePath(this.events.get(1).getEventType());
        return !isDroppedImmediately && this.hasInput() && this.hasOutput();
    }

    public boolean hasInput() {
        return this.refs != null && !this.refs.getInputs().isEmpty() || this.parents.stream().anyMatch(parent -> parent.hasInput());
    }

    public boolean hasOutput() {
        return this.refs != null && !this.refs.getOutputs().isEmpty() || this.parents.stream().anyMatch(parent -> parent.hasOutput());
    }

    public long getLineagePathHash() {
        return this.lineagePathHash;
    }

    public void setLineagePathHash(long lineagePathHash) {
        this.lineagePathHash = lineagePathHash;
    }
}

