/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.lineage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.notification.HookNotificationV1;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.NiFiFlow;
import org.apache.nifi.atlas.NiFiFlowPath;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.NiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.NiFiProvenanceEventAnalyzerFactory;
import org.apache.nifi.atlas.provenance.lineage.LineageContext;
import org.apache.nifi.atlas.provenance.lineage.LineageStrategy;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineageStrategy
implements LineageStrategy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private LineageContext lineageContext;

    @Override
    public void setLineageContext(LineageContext lineageContext) {
        this.lineageContext = lineageContext;
    }

    protected DataSetRefs executeAnalyzer(AnalysisContext analysisContext, ProvenanceEventRecord event) {
        NiFiProvenanceEventAnalyzer analyzer = NiFiProvenanceEventAnalyzerFactory.getAnalyzer(event.getComponentType(), event.getTransitUri(), event.getEventType());
        if (analyzer == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Analyzer {} is found for event: {}", (Object)analyzer, (Object)event);
        }
        return analyzer.analyze(analysisContext, event);
    }

    protected void addDataSetRefs(NiFiFlow nifiFlow, DataSetRefs refs) {
        Set<NiFiFlowPath> flowPaths = refs.getComponentIds().stream().map(componentId -> {
            NiFiFlowPath flowPath = nifiFlow.findPath((String)componentId);
            if (flowPath == null) {
                this.logger.warn("FlowPath for {} was not found.", componentId);
            }
            return flowPath;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.addDataSetRefs(nifiFlow, flowPaths, refs);
    }

    protected void addDataSetRefs(NiFiFlow nifiFlow, Set<NiFiFlowPath> flowPaths, DataSetRefs refs) {
        Referenceable flowRef = this.toReferenceable(nifiFlow);
        String namespace = nifiFlow.getNamespace();
        String url = nifiFlow.getUrl();
        for (NiFiFlowPath flowPath : flowPaths) {
            Referenceable flowPathRef = this.toReferenceable(flowPath, flowRef, namespace, url);
            this.addDataSetRefs(refs, flowPathRef);
        }
    }

    private Referenceable toReferenceable(NiFiFlow nifiFlow) {
        Referenceable flowRef = new Referenceable("nifi_flow", new String[0]);
        flowRef.set("name", (Object)nifiFlow.getFlowName());
        flowRef.set("qualifiedName", (Object)nifiFlow.getQualifiedName());
        flowRef.set("url", (Object)nifiFlow.getUrl());
        return flowRef;
    }

    protected Referenceable toReferenceable(NiFiFlowPath flowPath, NiFiFlow nifiFlow) {
        return this.toReferenceable(flowPath, this.toReferenceable(nifiFlow), nifiFlow.getNamespace(), nifiFlow.getUrl());
    }

    private Referenceable toReferenceable(NiFiFlowPath flowPath, Referenceable flowRef, String namespace, String nifiUrl) {
        Referenceable flowPathRef = new Referenceable("nifi_flow_path", new String[0]);
        flowPathRef.set("name", (Object)flowPath.getName());
        flowPathRef.set("qualifiedName", (Object)(flowPath.getId() + "@" + namespace));
        flowPathRef.set("nifiFlow", (Object)flowRef);
        flowPathRef.set("url", (Object)flowPath.createDeepLinkURL(nifiUrl));
        flowPathRef.set("inputs", flowPath.getInputs().stream().map(this::toReferenceable).collect(Collectors.toList()));
        flowPathRef.set("outputs", flowPath.getOutputs().stream().map(this::toReferenceable).collect(Collectors.toList()));
        return flowPathRef;
    }

    private Referenceable toReferenceable(AtlasObjectId id) {
        return StringUtils.isEmpty((String)id.getGuid()) ? new Referenceable(id.getTypeName(), id.getUniqueAttributes()) : new Referenceable(id.getGuid(), id.getTypeName(), id.getUniqueAttributes());
    }

    protected void createEntity(Referenceable ... entities) {
        HookNotificationV1.EntityCreateRequest msg = new HookNotificationV1.EntityCreateRequest("nifi", entities);
        this.lineageContext.addMessage((HookNotification)msg);
    }

    protected boolean addDataSetRefs(Set<Referenceable> refsToAdd, Referenceable nifiFlowPath, String targetAttribute) {
        if (refsToAdd != null && !refsToAdd.isEmpty()) {
            Function<Referenceable, String> toTypedQualifiedName = ref -> AtlasUtils.toTypedQualifiedName(ref.getTypeName(), AtlasUtils.toStr(ref.get("qualifiedName")));
            Collection refs = Optional.ofNullable((Collection)nifiFlowPath.get(targetAttribute)).orElseGet(ArrayList::new);
            Set existingRefTypedQualifiedNames = refs.stream().map(toTypedQualifiedName).collect(Collectors.toSet());
            refsToAdd.stream().filter(ref -> !existingRefTypedQualifiedNames.contains(toTypedQualifiedName.apply((Referenceable)ref))).forEach(ref -> {
                if (this.isUnassigned(ref.getId())) {
                    this.logger.debug("Found a new DataSet reference from {} to {}, sending an EntityCreateRequest", new Object[]{toTypedQualifiedName.apply(nifiFlowPath), toTypedQualifiedName.apply((Referenceable)ref)});
                    HookNotificationV1.EntityCreateRequest createDataSet = new HookNotificationV1.EntityCreateRequest("nifi", new Referenceable[]{ref});
                    this.lineageContext.addMessage((HookNotification)createDataSet);
                }
                refs.add(ref);
            });
            if (refs.size() > existingRefTypedQualifiedNames.size()) {
                nifiFlowPath.set(targetAttribute, (Object)refs);
                return true;
            }
        }
        return false;
    }

    protected void addDataSetRefs(DataSetRefs dataSetRefs, Referenceable flowPathRef) {
        boolean inputsAdded = this.addDataSetRefs(dataSetRefs.getInputs(), flowPathRef, "inputs");
        boolean outputsAdded = this.addDataSetRefs(dataSetRefs.getOutputs(), flowPathRef, "outputs");
        if (inputsAdded || outputsAdded) {
            this.lineageContext.addMessage((HookNotification)new HookNotificationV1.EntityPartialUpdateRequest("nifi", "nifi_flow_path", "qualifiedName", (String)flowPathRef.get("qualifiedName"), flowPathRef));
        }
    }

    private boolean isUnassigned(Id id) {
        try {
            long l = Long.parseLong(id.getId());
            return l < 0L;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }
}

