/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.net.URI;
import java.util.Set;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.analyzer.AbstractHiveAnalyzer;
import org.apache.nifi.atlas.provenance.analyzer.DatabaseAnalyzerUtil;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.Tuple;

public class PutHiveStreaming
extends AbstractHiveAnalyzer {
    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        if (event.getTransitUri() == null) {
            return null;
        }
        URI uri = this.parseUri(event.getTransitUri());
        String namespace = context.getNamespaceResolver().fromHostNames(uri.getHost());
        Set<Tuple<String, String>> outputTables = DatabaseAnalyzerUtil.parseTableNames(null, event.getAttribute(DatabaseAnalyzerUtil.ATTR_OUTPUT_TABLES));
        if (outputTables.isEmpty()) {
            return null;
        }
        DataSetRefs refs = new DataSetRefs(event.getComponentId());
        outputTables.forEach(tableName -> {
            Referenceable ref = this.createTableRef(namespace, (Tuple<String, String>)tableName);
            refs.addOutput(ref);
        });
        return refs;
    }

    @Override
    public String targetComponentTypePattern() {
        return "^PutHive(3)?Streaming$";
    }
}

